/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.cert.CacheableCertStore;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.Thumbprint;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertUtil;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPCertificateStore
extends CertificateStore
implements CacheableCertStore {
    private static final Logger log = LoggerFactory.getLogger(LDAPCertificateStore.class);
    private static final String CACHE_NAME = "LDAP_REMOTE_CERT_CACHE";
    protected static final int DEFAULT_LDAP_MAX_CAHCE_ITEMS = 1000;
    protected static final int DEFAULT_LDAP_TTL = 3600;
    protected CertificateStore localStoreDelegate;
    protected JCS cache;
    protected CertStoreCachePolicy cachePolicy;
    protected LdapCertUtil ldapCertUtil;

    public LDAPCertificateStore() {
        this.createCache();
    }

    public LDAPCertificateStore(LdapCertUtilImpl ldapCertUtil, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        this((LdapCertUtil)ldapCertUtil, bootstrapStore, policy);
    }

    public LDAPCertificateStore(LdapCertUtil ldapCertUtil, CertificateStore bootstrapStore, CertStoreCachePolicy policy) {
        this.ldapCertUtil = ldapCertUtil;
        this.cachePolicy = policy;
        this.createCache();
        if (bootstrapStore != null) {
            this.localStoreDelegate = bootstrapStore;
            this.loadBootStrap();
        }
    }

    protected synchronized JCS getCache() {
        if (this.cache == null) {
            this.createCache();
        }
        return this.cache;
    }

    private void createCache() {
        try {
            this.cache = CertCacheFactory.getInstance().getCertCache(CACHE_NAME, this.cachePolicy == null ? this.getDefaultPolicy() : this.cachePolicy);
            if (this.cachePolicy == null) {
                this.cachePolicy = this.getDefaultPolicy();
            }
        }
        catch (CacheException e) {
            log.warn("LDAPCertificateStore - Could not create certificate cache {}", (Object)CACHE_NAME, (Object)e);
        }
    }

    private void applyCachePolicy(CertStoreCachePolicy policy) {
        if (this.getCache() != null) {
            try {
                ICompositeCacheAttributes attributes = this.cache.getCacheAttributes();
                attributes.setMaxObjects(policy.getMaxItems());
                attributes.setUseLateral(false);
                attributes.setUseRemote(false);
                this.cache.setCacheAttributes(attributes);
                IElementAttributes eattributes = this.cache.getDefaultElementAttributes();
                eattributes.setMaxLifeSeconds((long)policy.getSubjectTTL());
                eattributes.setIsEternal(false);
                eattributes.setIsLateral(false);
                eattributes.setIsRemote(false);
                this.cache.setDefaultElementAttributes(eattributes);
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
        }
    }

    private CertStoreCachePolicy getDefaultPolicy() {
        return new DefaultLDAPCachePolicy();
    }

    protected CertificateStore createDefaultLocalStore() {
        KeyStoreCertificateStore retVal = new KeyStoreCertificateStore(new File("NHINKeyStore"), "nH!NdK3yStor3", "31visl!v3s");
        return retVal;
    }

    @Override
    public void add(X509Certificate cert) {
        if (this.contains(cert)) {
            throw new IllegalArgumentException("Cert already contained in store.  Use update() to update a certificate");
        }
    }

    @Override
    public boolean contains(X509Certificate cert) {
        String subject = CryptoExtensions.getSubjectAddress((X509Certificate)cert);
        Collection<X509Certificate> foundCerts = subject == null || subject.isEmpty() ? this.getAllCertificates() : this.getCertificates(subject);
        if (foundCerts != null) {
            Thumbprint searchCertTP = Thumbprint.toThumbprint(cert);
            for (X509Certificate foundCert : foundCerts) {
                if (!Thumbprint.toThumbprint(foundCert).equals(searchCertTP)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<X509Certificate> getCertificates(String subjectName) {
        Collection<X509Certificate> retVal;
        int index = subjectName.indexOf("EMAILADDRESS=");
        String realSubjectName = index > -1 ? subjectName.substring(index + "EMAILADDRESS=".length()) : subjectName;
        JCS cache = this.getCache();
        if (cache != null) {
            retVal = (Collection<X509Certificate>)cache.get((Object)realSubjectName);
            if (retVal == null || retVal.size() == 0) {
                retVal = this.ldapCertUtil.ldapSearch(realSubjectName);
                if (retVal != null && retVal.size() > 0) {
                    if (!subjectName.contains("*")) {
                        try {
                            cache.putSafe((Object)realSubjectName, retVal);
                        }
                        catch (CacheException e) {
                            log.error("Error adding certificates to the cache: {}", (Object)e.getMessage(), (Object)e);
                        }
                        if (this.localStoreDelegate != null) {
                            this.addOrUpdateLocalStoreDelegate(retVal);
                        }
                    }
                } else if (this.localStoreDelegate != null) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                }
                if (retVal == null || retVal.size() == 0) {
                    log.info("getCertificates(String subjectName) - Could not find an LDAP certificate for subject {}", (Object)subjectName);
                }
            }
        } else {
            retVal = this.ldapCertUtil.ldapSearch(realSubjectName);
            if (this.localStoreDelegate != null) {
                if (retVal == null || retVal.size() == 0) {
                    retVal = this.localStoreDelegate.getCertificates(realSubjectName);
                } else if (!subjectName.contains("*")) {
                    this.addOrUpdateLocalStoreDelegate(retVal);
                }
            }
            if (retVal == null || retVal.size() == 0) {
                log.info("getCertificates(String subjectName) - Could not find an LDAP certificate for subject {}", (Object)subjectName);
            }
        }
        return retVal;
    }

    protected void addOrUpdateLocalStoreDelegate(Collection<X509Certificate> retVal) {
        if (this.localStoreDelegate != null && retVal != null && this.localStoreDelegate != null) {
            for (X509Certificate cert : retVal) {
                if (this.localStoreDelegate.contains(cert)) {
                    this.localStoreDelegate.update(cert);
                    continue;
                }
                this.localStoreDelegate.add(cert);
            }
        }
    }

    @Override
    public Collection<X509Certificate> getAllCertificates() {
        return this.getCertificates("*");
    }

    @Override
    public void remove(X509Certificate cert) {
    }

    @Override
    public void flush(boolean purgeBootStrap) {
        JCS cache = this.getCache();
        if (cache != null) {
            try {
                cache.clear();
            }
            catch (CacheException e) {
                log.warn("Failed to clear cache {}LDAP_REMOTE_CERT_CACHE");
            }
        }
    }

    @Override
    public void loadBootStrap() {
        this.getCache();
    }

    @Override
    public void loadBootStrap(CertificateStore bootstrapStore) {
        this.getCache();
    }

    @Override
    public void setBootStrap(CertificateStore bootstrapStore) {
        this.getCache();
    }

    @Override
    public void setCachePolicy(CertStoreCachePolicy policy) {
        this.cachePolicy = policy;
        this.applyCachePolicy(policy);
    }

    public static class DefaultLDAPCachePolicy
    implements CertStoreCachePolicy {
        protected final int maxItems;
        protected final int subjectTTL;

        public DefaultLDAPCachePolicy() {
            OptionsParameter param = OptionsManager.getInstance().getParameter("LDAP_CERT_RESOLVER_MAX_CACHE_SIZE");
            this.maxItems = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)1000);
            param = OptionsManager.getInstance().getParameter("LDAP_CERT_RESOLVER_CACHE_TTL");
            this.subjectTTL = OptionsParameter.getParamValueAsInteger((OptionsParameter)param, (int)3600);
        }

        @Override
        public int getMaxItems() {
            return this.maxItems;
        }

        @Override
        public int getSubjectTTL() {
            return this.subjectTTL;
        }
    }
}

