/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools.certgen;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cert.tools.certgen.CertCreateFields;

public class CertLoader {
    public static CertCreateFields loadCertificate(File certFile, File keyFile, char[] password) throws Exception {
        byte[] certData = CertLoader.loadFileData(certFile);
        byte[] keyData = CertLoader.loadFileData(keyFile);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream inStr = new ByteArrayInputStream(certData);
        Certificate holdCert = cf.generateCertificate(inStr);
        X509Certificate cert = (X509Certificate)holdCert;
        IOUtils.closeQuietly((InputStream)inStr);
        KeyFactory kf = KeyFactory.getInstance("RSA", CryptoExtensions.getJCEProviderName());
        PKCS8EncodedKeySpec keysp = null;
        if (password != null && password.length > 0) {
            EncryptedPrivateKeyInfo encInfo = new EncryptedPrivateKeyInfo(keyData);
            PBEKeySpec keySpec = new PBEKeySpec(password);
            String alg = encInfo.getAlgName();
            SecretKeyFactory secFactory = SecretKeyFactory.getInstance(alg, CryptoExtensions.getJCEProviderName());
            SecretKey secKey = secFactory.generateSecret(keySpec);
            keysp = encInfo.getKeySpec((Key)secKey, CryptoExtensions.getJCEProviderName());
        } else {
            keysp = new PKCS8EncodedKeySpec(keyData);
        }
        PrivateKey privKey = kf.generatePrivate(keysp);
        Map<String, Object> attributes = CertLoader.getAttributes(cert);
        Calendar now = Calendar.getInstance();
        Calendar exp = Calendar.getInstance();
        exp.setTime(cert.getNotAfter());
        long diff = exp.getTimeInMillis() - now.getTimeInMillis();
        long diffDays = diff / 86400000L;
        int keyStr = 1024;
        CertCreateFields retVal = new CertCreateFields(attributes, certFile, keyFile, password, (int)diffDays, keyStr, cert, privKey);
        return retVal;
    }

    private static Map<String, Object> getAttributes(X509Certificate cert) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = cert.getSubjectX500Principal().getName("RFC1779", oidMap);
        String[] attributes = prinName.split(",");
        if (attributes != null) {
            for (String attr : attributes) {
                String[] nameValue = attr.split("=");
                if (nameValue == null || nameValue.length != 2) continue;
                retVal.put(nameValue[0].trim(), nameValue[1].trim());
            }
        }
        return retVal;
    }

    private static byte[] loadFileData(File file) throws Exception {
        return FileUtils.readFileToByteArray((File)file);
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

