/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.SignatureValidationException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.CryptoAlgorithmsHelper;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.cryptography.SignatureError;
import org.nhindirect.stagent.cryptography.SignatureException;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.cryptography.bc.DirectJceKeyTransEnvelopedRecipient;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMIMECryptographerImpl
implements Cryptographer {
    private static final Logger log = LoggerFactory.getLogger(SMIMECryptographerImpl.class);
    public static final ASN1ObjectIdentifier x509CertificateObjectsIdent = new ASN1ObjectIdentifier("1.2.840.113549.1.9.22.1");
    public static final SMIMECryptographerImpl Default = new SMIMECryptographerImpl();
    protected EncryptionAlgorithm m_encryptionAlgorithm;
    protected EncryptionAlgorithm m_keyEncryptionAlgorithm;
    protected DigestAlgorithm m_keyEncryptionDigestAlgorithm;
    protected DigestAlgorithm m_digestAlgorithm;
    protected boolean m_includeEpilogue = true;
    protected boolean enforceStrongEncryption;
    protected boolean enforceStrongDigests;
    private boolean m_logDigest = false;

    public SMIMECryptographerImpl() {
        OptionsParameter param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_SMIME_ENCRYPTION_ALGORITHM");
        this.m_encryptionAlgorithm = param == null ? EncryptionAlgorithm.AES128 : EncryptionAlgorithm.fromString(param.getParamValue(), EncryptionAlgorithm.AES128);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_KEY_ENCRYPTION_ALGORITHM");
        this.m_keyEncryptionAlgorithm = param == null ? EncryptionAlgorithm.RSA_OAEP : EncryptionAlgorithm.fromString(param.getParamValue(), EncryptionAlgorithm.RSA_OAEP);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_KEY_ENCRYPTION_DIGEST_ALGORITHM");
        this.m_keyEncryptionDigestAlgorithm = param == null ? DigestAlgorithm.SHA1 : DigestAlgorithm.fromString(param.getParamValue(), DigestAlgorithm.SHA1);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_SMIME_DIGEST_ALGORITHM");
        DigestAlgorithm digestAlgorithm = this.m_digestAlgorithm = param == null ? DigestAlgorithm.SHA256WITHRSA : DigestAlgorithm.fromString(param.getParamValue(), DigestAlgorithm.SHA256WITHRSA);
        if (!this.isAllowedDigestAlgorithm(this.m_digestAlgorithm.getOID())) {
            throw new IllegalArgumentException("The digest algorithm " + this.m_digestAlgorithm.getAlgName() + " is not allowed");
        }
        param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_DIGESTS");
        this.enforceStrongDigests = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_ENCRYPTION");
        this.enforceStrongEncryption = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        this.m_logDigest = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)false);
    }

    public SMIMECryptographerImpl(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        this.m_encryptionAlgorithm = encryptionAlgorithm;
        this.m_digestAlgorithm = digestAlgorithm;
        OptionsParameter param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_DIGESTS");
        this.enforceStrongDigests = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        if (!this.isAllowedDigestAlgorithm(this.m_digestAlgorithm.getOID())) {
            throw new IllegalArgumentException("The digest algorith " + this.m_digestAlgorithm.getAlgName() + " is not allowed");
        }
        param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_ENCRYPTION");
        this.enforceStrongEncryption = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        this.m_logDigest = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)false);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_KEY_ENCRYPTION_ALGORITHM");
        this.m_keyEncryptionAlgorithm = param == null ? EncryptionAlgorithm.RSA_OAEP : EncryptionAlgorithm.fromString(param.getParamValue(), EncryptionAlgorithm.RSA_OAEP);
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_KEY_ENCRYPTION_DIGEST_ALGORITHM");
        this.m_keyEncryptionDigestAlgorithm = param == null ? DigestAlgorithm.SHA256 : DigestAlgorithm.fromString(param.getParamValue(), DigestAlgorithm.SHA256);
    }

    public SMIMECryptographerImpl(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, EncryptionAlgorithm keyEncryptionAlgorithm) {
        this.m_encryptionAlgorithm = encryptionAlgorithm;
        this.m_digestAlgorithm = digestAlgorithm;
        OptionsParameter param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_DIGESTS");
        this.enforceStrongDigests = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        if (!this.isAllowedDigestAlgorithm(this.m_digestAlgorithm.getOID())) {
            throw new IllegalArgumentException("The digest algorith " + this.m_digestAlgorithm.getAlgName() + " is not allowed");
        }
        param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_ENCRYPTION");
        this.enforceStrongEncryption = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        this.m_logDigest = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)false);
        this.m_keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        param = OptionsManager.getInstance().getParameter("CRYPTOGRAHPER_KEY_ENCRYPTION_DIGEST_ALGORITHM");
        this.m_keyEncryptionDigestAlgorithm = param == null ? DigestAlgorithm.SHA256 : DigestAlgorithm.fromString(param.getParamValue(), DigestAlgorithm.SHA256);
    }

    public SMIMECryptographerImpl(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, EncryptionAlgorithm keyEncryptionAlgorithm, DigestAlgorithm keyEncryptionDigestAlgorithm) {
        this.m_encryptionAlgorithm = encryptionAlgorithm;
        this.m_digestAlgorithm = digestAlgorithm;
        OptionsParameter param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_DIGESTS");
        this.enforceStrongDigests = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        if (!this.isAllowedDigestAlgorithm(this.m_digestAlgorithm.getOID())) {
            throw new IllegalArgumentException("The digest algorith " + this.m_digestAlgorithm.getAlgName() + " is not allowed");
        }
        param = OptionsManager.getInstance().getParameter("ENFORCE_STRONG_ENCRYPTION");
        this.enforceStrongEncryption = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)true);
        this.m_logDigest = OptionsParameter.getParamValueAsBoolean((OptionsParameter)param, (boolean)false);
        this.m_keyEncryptionAlgorithm = keyEncryptionAlgorithm;
        this.m_keyEncryptionDigestAlgorithm = keyEncryptionDigestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.m_encryptionAlgorithm;
    }

    public EncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.m_keyEncryptionAlgorithm;
    }

    public DigestAlgorithm getKeyEncryptionDigestAlgorithm() {
        return this.m_keyEncryptionDigestAlgorithm;
    }

    public void setEncryptionAlgorithm(EncryptionAlgorithm value) {
        this.m_encryptionAlgorithm = value;
    }

    public void setKeyEncryptionAlgorithm(EncryptionAlgorithm value) {
        this.m_keyEncryptionAlgorithm = value;
    }

    public void setKeyEncryptionDigestAlgorithm(DigestAlgorithm value) {
        this.m_keyEncryptionDigestAlgorithm = value;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    public void setDigestAlgorithm(DigestAlgorithm value) {
        if (!this.isAllowedDigestAlgorithm(value.getOID())) {
            throw new IllegalArgumentException("The digest algorithm " + this.m_digestAlgorithm.getAlgName() + " is not allowed");
        }
        this.m_digestAlgorithm = value;
    }

    public boolean isLogDigests() {
        return this.m_logDigest;
    }

    public void setStrongDigestEnforced(Boolean value) {
        this.enforceStrongDigests = value;
    }

    public boolean isStrongDigestEnforced() {
        return this.enforceStrongDigests;
    }

    public void setLogDigests(boolean m_logDigest) {
        this.m_logDigest = m_logDigest;
    }

    public void setStrongEncryptionEnforced(Boolean value) {
        this.enforceStrongEncryption = value;
    }

    public boolean isStrongEncryptionEnforced() {
        return this.enforceStrongEncryption;
    }

    public boolean isIncludeMultipartEpilogueInSignature() {
        return this.m_includeEpilogue;
    }

    public void setIncludeMultipartEpilogueInSignature(boolean value) {
        this.m_includeEpilogue = value;
    }

    @Override
    public MimeEntity encrypt(MimeMultipart entity, X509Certificate encryptingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(encryptingCertificate);
        return this.encrypt(entity, certs);
    }

    @Override
    public MimeEntity encrypt(MimeMultipart mmEntity, Collection<X509Certificate> encryptingCertificates) {
        MimeEntity entToEncrypt = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        try {
            mmEntity.writeTo((OutputStream)oStream);
            oStream.flush();
            InternetHeaders headers = new InternetHeaders();
            headers.addHeader("Content-Type", mmEntity.getContentType());
            entToEncrypt = new MimeEntity(headers, oStream.toByteArray());
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidMimeEntity, e);
        }
        return this.encrypt(entToEncrypt, encryptingCertificates);
    }

    @Override
    public MimeEntity encrypt(MimeEntity entity, X509Certificate encryptingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(encryptingCertificate);
        return this.encrypt(entity, (Collection<X509Certificate>)certs);
    }

    @Override
    public MimeEntity encrypt(MimeEntity entity, Collection<X509Certificate> encryptingCertificates) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        MimeEntity partToEncrypt = entity;
        MimeBodyPart encryptedPart = this.encrypt((MimeBodyPart)partToEncrypt, encryptingCertificates);
        MimeEntity encryptedEntity = null;
        try {
            byte[] encBytes = EntitySerializer.Default.serializeToBytes((MimePart)encryptedPart);
            ByteArrayInputStream inStream = new ByteArrayInputStream(EntitySerializer.Default.serializeToBytes((MimePart)encryptedPart));
            encryptedEntity = new MimeEntity(inStream);
            if (log.isDebugEnabled()) {
                this.writePostEncypt(encBytes);
            }
            encryptedEntity.setHeader("Content-Type", "application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return encryptedEntity;
    }

    private MimeBodyPart encrypt(MimeBodyPart bodyPart, Collection<X509Certificate> encryptingCertificates) {
        return this.createEncryptedEnvelope(bodyPart, encryptingCertificates);
    }

    private MimeBodyPart createEncryptedEnvelope(MimeBodyPart bodyPart, Collection<X509Certificate> encryptingCertificates) {
        if (bodyPart == null || encryptingCertificates == null || encryptingCertificates.size() == 0) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            this.writePreEncypt(EntitySerializer.Default.serializeToBytes((MimePart)bodyPart));
        }
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        if (!this.isAllowedKeyEncryptionAlgorithm(this.m_keyEncryptionAlgorithm.getOID())) {
            throw new NHINDException((Object)MimeError.DisallowedEncryptionAlgorithm, "The key encryption algorithm " + this.m_keyEncryptionAlgorithm.algName + "(" + this.m_keyEncryptionAlgorithm.getOID() + ") is not allowed");
        }
        if (this.m_keyEncryptionDigestAlgorithm != null && !this.isAllowedKeyEncryptionDigestAlgorithm(this.m_keyEncryptionDigestAlgorithm.getOID())) {
            throw new NHINDException((Object)MimeError.DisallowedEncryptionAlgorithm, "The key encryption algorithm " + this.m_keyEncryptionDigestAlgorithm.algName + "(" + this.m_keyEncryptionDigestAlgorithm.getOID() + ") is not allowed");
        }
        MimeBodyPart retVal = null;
        try {
            for (X509Certificate cert : encryptingCertificates) {
                if (!this.isAllowedCertKey(cert)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Encrypting: Encryption algorithm is " + this.m_encryptionAlgorithm.algName + "(" + this.m_encryptionAlgorithm.getOID().toString() + ")");
                    log.debug("Encrypting: Key encryption algorithm is " + this.m_keyEncryptionAlgorithm.algName + "(" + this.m_keyEncryptionAlgorithm.getOID().toString() + ")");
                }
                JcaAlgorithmParametersConverter paramsConverter = new JcaAlgorithmParametersConverter();
                if (this.m_keyEncryptionAlgorithm == EncryptionAlgorithm.RSA_OAEP) {
                    OAEPParameterSpec oaepSpec = null;
                    if (this.m_keyEncryptionDigestAlgorithm == DigestAlgorithm.SHA256) {
                        oaepSpec = new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
                    }
                    if (this.m_keyEncryptionDigestAlgorithm == DigestAlgorithm.SHA384) {
                        oaepSpec = new OAEPParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, PSource.PSpecified.DEFAULT);
                    }
                    if (this.m_keyEncryptionDigestAlgorithm == DigestAlgorithm.SHA512) {
                        oaepSpec = new OAEPParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, PSource.PSpecified.DEFAULT);
                    }
                    if (this.m_keyEncryptionDigestAlgorithm == DigestAlgorithm.SHA1) {
                        oaepSpec = new OAEPParameterSpec("SHA-1", "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
                    }
                    AlgorithmIdentifier algorithmIdentifier = paramsConverter.getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)oaepSpec);
                    if (log.isDebugEnabled()) {
                        ASN1Encodable asn1Encodable = algorithmIdentifier.getParameters();
                        RSAESOAEPparams rsaesoaePparams = (RSAESOAEPparams)asn1Encodable;
                        log.debug("Encrypting: Key encryption algorithm parameters: Hash Algorithm: " + rsaesoaePparams.getHashAlgorithm().getAlgorithm().getId() + " Mask Gen Algorithm: " + rsaesoaePparams.getMaskGenAlgorithm().getAlgorithm().getId() + " P Source Algorithm: " + rsaesoaePparams.getPSourceAlgorithm().getAlgorithm().getId());
                    }
                    JceKeyTransRecipientInfoGenerator jceKey = new JceKeyTransRecipientInfoGenerator(cert, algorithmIdentifier).setProvider(CryptoExtensions.getJCEProviderName());
                    gen.addRecipientInfoGenerator((RecipientInfoGenerator)jceKey);
                }
                if (this.m_keyEncryptionAlgorithm != EncryptionAlgorithm.RSA_PKCS1_V15) continue;
                gen.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider(CryptoExtensions.getJCEProviderName()));
            }
            ASN1ObjectIdentifier encryAlgOID = new ASN1ObjectIdentifier(this.m_encryptionAlgorithm.getOID());
            OutputEncryptor encryptor = new JceCMSContentEncryptorBuilder(encryAlgOID).setProvider(CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"Cipher", (String)this.m_encryptionAlgorithm.getOID())).build();
            retVal = gen.generate(bodyPart, encryptor);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        return retVal;
    }

    @Override
    public MimeEntity decrypt(Message message, X509CertificateEx decryptingCertificate) {
        return this.decrypt(message.extractMimeEntity(), decryptingCertificate);
    }

    @Override
    public MimeEntity decrypt(MimeEntity encryptedEntity, X509CertificateEx decryptingCertificate) {
        if (encryptedEntity == null || decryptingCertificate == null) {
            throw new IllegalArgumentException();
        }
        if (!decryptingCertificate.hasPrivateKey()) {
            throw new IllegalArgumentException("Certificate has no private key");
        }
        encryptedEntity.verifyContentType("application/pkcs7-mime; smime-type=enveloped-data; name=\"smime.p7m\"");
        encryptedEntity.verifyTransferEncoding("base64");
        ArrayList<X509CertificateEx> certs = new ArrayList<X509CertificateEx>();
        certs.add(decryptingCertificate);
        MimeEntity retVal = this.decrypt(encryptedEntity, certs);
        return retVal;
    }

    @Override
    public MimeEntity decrypt(MimeEntity encryptedEntity, Collection<X509CertificateEx> decryptingCertificates) {
        if (decryptingCertificates == null || decryptingCertificates.size() == 0) {
            throw new IllegalArgumentException();
        }
        MimeEntity retEntity = null;
        try {
            SMIMEEnveloped m;
            if (log.isDebugEnabled()) {
                byte[] encryptedContent = encryptedEntity.getContentAsBytes();
                this.writePreDecrypt(encryptedContent);
            }
            if (!this.isAllowedEncryptionAlgorithm((m = new SMIMEEnveloped((MimeBodyPart)encryptedEntity)).getEncryptionAlgOID())) {
                throw new NHINDException((Object)MimeError.DisallowedEncryptionAlgorithm, "The encryption algorithm " + m.getEncryptionAlgOID() + " is not allowed");
            }
            for (X509CertificateEx decryptCert : decryptingCertificates) {
                if (!this.isAllowedCertKey(decryptCert)) continue;
                RecipientId recId = this.generateRecipientSelector(decryptCert);
                RecipientInformationStore recipients = m.getRecipientInfos();
                RecipientInformation recipient = recipients.get(recId);
                if (recipient == null) continue;
                DefaultAlgorithmNameFinder defaultAlgorithmNameFinder = new DefaultAlgorithmNameFinder();
                log.debug("Decrypting: Encryption algorithm is " + defaultAlgorithmNameFinder.getAlgorithmName(m.getContentEncryptionAlgorithm()) + "(" + m.getEncryptionAlgOID() + ")");
                log.debug("Decrypting: Key encryption algorithm is " + defaultAlgorithmNameFinder.getAlgorithmName(recipient.getKeyEncryptionAlgorithm()) + "(" + recipient.getKeyEncryptionAlgorithm().getAlgorithm().getId() + ")");
                if (recipient.getKeyEncryptionAlgorithm().getParameters() != null) {
                    ASN1Encodable asn1Encodable = recipient.getKeyEncryptionAlgorithm().getParameters();
                    RSAESOAEPparams rsaesoaePparams = null;
                    if (asn1Encodable instanceof DERSequence) {
                        DERSequence derSequence = (DERSequence)asn1Encodable;
                        rsaesoaePparams = RSAESOAEPparams.getInstance((Object)derSequence);
                    }
                    if (asn1Encodable instanceof DLSequence) {
                        DLSequence dlSequence = (DLSequence)asn1Encodable;
                        rsaesoaePparams = RSAESOAEPparams.getInstance((Object)dlSequence);
                    }
                    if (rsaesoaePparams != null) {
                        log.info("Decrypting: Key encryption algorithm parameters: Hash Algorithm: " + rsaesoaePparams.getHashAlgorithm().getAlgorithm().getId() + "(" + defaultAlgorithmNameFinder.getAlgorithmName(new ASN1ObjectIdentifier(rsaesoaePparams.getHashAlgorithm().getAlgorithm().getId())) + ") Mask Gen Algorithm: " + rsaesoaePparams.getMaskGenAlgorithm().getAlgorithm().getId() + "(" + SMIMECryptographerImpl.getMaskFunctionGeneratorFromOID(rsaesoaePparams.getMaskGenAlgorithm().getAlgorithm().getId()) + ") P Source Algorithm: " + rsaesoaePparams.getPSourceAlgorithm().getAlgorithm().getId());
                    }
                }
                DirectJceKeyTransEnvelopedRecipient recip = new DirectJceKeyTransEnvelopedRecipient(decryptCert.getPrivateKey());
                recip.setProvider(CryptoExtensions.getJCESensitiveProviderName());
                recip.setContentProvider(CryptoExtensions.getJCEProviderName());
                byte[] decryptedPayload = recipient.getContent((Recipient)recip);
                if (log.isDebugEnabled()) {
                    this.writePostDecrypt(decryptedPayload);
                }
                ByteArrayInputStream inStream = new ByteArrayInputStream(decryptedPayload);
                retEntity = new MimeEntity(inStream);
                break;
            }
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new MimeException(MimeError.Unexpected, e);
        }
        if (retEntity == null) {
            throw new NHINDException((Object)MimeError.Unexpected, "None of the the provided decryption certs were found in message's RecipientsInfo set.");
        }
        return retEntity;
    }

    private RecipientId generateRecipientSelector(X509Certificate decryptCert) {
        JceKeyTransRecipientId retVal;
        block2: {
            retVal = null;
            try {
                retVal = new JceKeyTransRecipientId(decryptCert);
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block2;
                StringBuilder builder = new StringBuilder("bcmail-jdk15-146 org.bouncycastle.cms.jcajce.JceKeyTransRecipientId class not found.");
                builder.append("\r\n\tAttempt to fall back to bcmail-jdk15-140 org.bouncycastle.cms.RecipientId");
                log.debug(builder.toString());
            }
        }
        return retVal;
    }

    @Override
    public SignedEntity sign(Message message, X509Certificate signingCertificate) {
        return this.sign(message.extractEntityForSignature(this.m_includeEpilogue), signingCertificate);
    }

    @Override
    public SignedEntity sign(Message message, Collection<X509Certificate> signingCertificates) {
        return this.sign(message.extractEntityForSignature(this.m_includeEpilogue), signingCertificates);
    }

    @Override
    public SignedEntity sign(MimeEntity entity, X509Certificate signingCertificate) {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        certs.add(signingCertificate);
        return this.sign(entity, certs);
    }

    @Override
    public SignedEntity sign(MimeEntity entity, Collection<X509Certificate> signingCertificates) {
        if (entity == null) {
            throw new IllegalArgumentException();
        }
        byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        MimeMultipart mm = this.createSignatureEntity(messageBytes, signingCertificates);
        SignedEntity retVal = null;
        try {
            retVal = new SignedEntity(new ContentType(mm.getContentType()), mm);
        }
        catch (ParseException e) {
            throw new MimeException(MimeError.InvalidHeader, (Exception)((Object)e));
        }
        return retVal;
    }

    protected MimeMultipart createSignatureEntity(byte[] entity, Collection<X509Certificate> signingCertificates) {
        MimeMultipart retVal = null;
        try {
            MimeBodyPart signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(entity));
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.dES_EDE3_CBC);
            caps.addCapability(SMIMECapability.rC2_CBC, 128);
            caps.addCapability(SMIMECapability.dES_CBC);
            caps.addCapability(new ASN1ObjectIdentifier("1.2.840.113549.1.7.1"));
            caps.addCapability(x509CertificateObjectsIdent);
            signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            for (X509Certificate signer : signingCertificates) {
                if (!(signer instanceof X509CertificateEx) || !this.isAllowedCertKey(signer)) continue;
                ContentSigner digestSigner = new JcaContentSignerBuilder(this.m_digestAlgorithm.getAlgName()).setProvider(CryptoExtensions.getJCESensitiveProviderName()).build(((X509CertificateEx)signer).getPrivateKey());
                gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build()).build(digestSigner, signer));
                certList.add(signer);
            }
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            CMSProcessableByteArray content = new CMSProcessableByteArray(entity);
            CMSSignedData signedData = gen.generate((CMSTypedData)content);
            String header = "signed; protocol=\"application/pkcs7-signature\"; micalg=" + CryptoAlgorithmsHelper.toDigestAlgorithmMicalg(this.m_digestAlgorithm);
            String encodedSig = StringUtils.toEncodedString((byte[])Base64.encodeBase64((byte[])signedData.getEncoded(), (boolean)true), (Charset)StandardCharsets.UTF_8);
            retVal = new MimeMultipart(header.toString());
            MimeBodyPart sig = new MimeBodyPart(new InternetHeaders(), encodedSig.getBytes("ASCII"));
            sig.addHeader("Content-Type", "application/pkcs7-signature; name=smime.p7s; smime-type=signed-data");
            sig.addHeader("Content-Disposition", "attachment; filename=\"smime.p7s\"");
            sig.addHeader("Content-Description", "S/MIME Cryptographic Signature");
            sig.addHeader("Content-Transfer-Encoding", "base64");
            retVal.addBodyPart((BodyPart)signedContent);
            retVal.addBodyPart((BodyPart)sig);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SignatureException(SignatureError.InvalidMultipartSigned, (Exception)e);
        }
        catch (Exception e) {
            throw new NHINDException((Object)MimeError.Unexpected, e);
        }
        return retVal;
    }

    public static AttributeTable createAttributeTable(ASN1EncodableVector signedAttrs) {
        AttributeTable retVal = null;
        if (retVal == null) {
            try {
                Constructor constr = AttributeTable.class.getConstructor(ASN1EncodableVector.class);
                retVal = (AttributeTable)constr.newInstance(signedAttrs);
            }
            catch (Throwable t) {
                log.error("Attempt to use to bcmail-jdk15-146 DERObjectIdentifier(ASN1EncodableVector constructor failed.", t);
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkSignature(SignedEntity signedEntity, X509Certificate signerCertificate, Collection<X509Certificate> anchors) throws SignatureValidationException {
        if (!this.isAllowedCertKey(signerCertificate)) {
            throw new SignatureValidationException("Signing certificate key size/strength is not allowed");
        }
        CMSSignedData signatureEnvelope = this.deserializeSignatureEnvelope(signedEntity);
        SignerInformation logSigInfo = null;
        try {
            Iterator iterator = signatureEnvelope.getSignerInfos().getSigners().iterator();
            while (iterator.hasNext()) {
                SignerInformation sigInfo;
                logSigInfo = sigInfo = (SignerInformation)iterator.next();
                if (!this.isAllowedDigestAlgorithm(sigInfo.getDigestAlgOID())) {
                    throw new SignatureValidationException("Digest algorithm " + sigInfo.getDigestAlgOID() + " is not allowed.");
                }
                if (!sigInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build(signerCertificate))) continue;
                this.logDigests(logSigInfo);
                return;
            }
            throw new SignatureValidationException("Signature validation failure.");
        }
        catch (SignatureValidationException sve) {
            throw sve;
        }
        catch (Exception e) {
            throw new SignatureValidationException("Signature validation failure.", e);
        }
        catch (Throwable throwable) {
            this.logDigests(logSigInfo);
            throw throwable;
        }
    }

    protected boolean isAllowedDigestAlgorithm(String digestOID) {
        return !digestOID.equalsIgnoreCase(DigestAlgorithm.MD5.getOID()) && !digestOID.equalsIgnoreCase(DigestAlgorithm.SHA1.getOID()) && !digestOID.equalsIgnoreCase(DigestAlgorithm.SHA1WITHRSA.getOID());
    }

    protected boolean isAllowedEncryptionAlgorithm(String encryptionOID) {
        if (!this.isStrongEncryptionEnforced()) {
            return true;
        }
        return !encryptionOID.equalsIgnoreCase(EncryptionAlgorithm.DES_EDE3_CBC.getOID());
    }

    protected boolean isAllowedKeyEncryptionAlgorithm(String encryptionOID) {
        if (!this.isStrongEncryptionEnforced()) {
            return true;
        }
        return true;
    }

    protected boolean isAllowedKeyEncryptionDigestAlgorithm(String digestOID) {
        if (!this.isStrongEncryptionEnforced()) {
            return true;
        }
        return true;
    }

    protected boolean isAllowedCertKey(X509Certificate cert) {
        if (cert.getPublicKey().getAlgorithm().contains("RSA")) {
            RSAPublicKey rsaPk = (RSAPublicKey)cert.getPublicKey();
            return rsaPk.getModulus().bitLength() >= 2048;
        }
        return true;
    }

    protected void logDigests(SignerInformation sigInfo) {
        if (this.m_logDigest && sigInfo != null) {
            try {
                Attribute digAttr = sigInfo.getSignedAttributes().get(CMSAttributes.messageDigest);
                ASN1Encodable hashObj = digAttr.getAttrValues().getObjectAt(0);
                byte[] signedDigest = ((ASN1OctetString)hashObj).getOctets();
                String signedDigestHex = Hex.encodeHexString((byte[])signedDigest);
                log.info("Signed Message Digest: {}", (Object)signedDigestHex);
                byte[] digest = sigInfo.getContentDigest();
                String digestHex = Hex.encodeHexString((byte[])digest);
                log.info("Computed Message Digest: {}", (Object)digestHex);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public CMSSignedData deserializeSignatureEnvelope(SignedEntity entity) {
        if (entity == null) {
            throw new NHINDException();
        }
        CMSSignedData signed = null;
        try {
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity.getContent());
            MimeBodyPart signedContent = null;
            signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            signed = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart((BodyPart)signedContent), entity.getMimeMultipart().getBodyPart(1).getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MimeException(MimeError.Unexpected, e);
        }
        return signed;
    }

    @Override
    public CMSSignedData deserializeEnvelopedSignature(MimeEntity envelopeEntity) {
        if (envelopeEntity == null) {
            throw new SignatureException(SignatureError.NullEntity);
        }
        if (!SMIMEStandard.isSignedEnvelope(envelopeEntity)) {
            throw new SignatureException(SignatureError.NotSignatureEnvelope);
        }
        byte[] envelopeBytes = EntitySerializer.Default.serializeToBytes((MimePart)envelopeEntity);
        return this.deserializeEnvelopedSignature(envelopeBytes);
    }

    @Override
    public CMSSignedData deserializeEnvelopedSignature(byte[] messageBytes) {
        CMSSignedData signed = null;
        try {
            signed = new CMSSignedData(messageBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MimeException(MimeError.Unexpected, e);
        }
        return signed;
    }

    private void writePreEncypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/preEncypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePostEncypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/postEncypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePreDecrypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/preDecrypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writePostDecrypt(byte[] message) {
        String path = System.getProperty("user.dir") + "/tmp";
        File tmpDir = new File(path);
        if (!tmpDir.exists() && !tmpDir.mkdir()) {
            return;
        }
        System.currentTimeMillis();
        File outFile = new File(path + "/postDecrypt_" + System.currentTimeMillis() + ".eml");
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                return;
            }
            BufferedOutputStream oStream = new BufferedOutputStream(new FileOutputStream(outFile));
            oStream.write(message, 0, message.length);
            oStream.flush();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMaskFunctionGeneratorFromOID(String mfgOID) {
        if (mfgOID.equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
            return "MGF1";
        }
        return "Unknown MFG: " + mfgOID;
    }
}

