/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.X509Store;
import org.nhindirect.stagent.cert.impl.UniformCertificateStore;
import org.nhindirect.stagent.trust.TrustAnchorResolver;

public class DefaultTrustAnchorResolver
implements TrustAnchorResolver {
    private CertificateResolver outgoingAnchors;
    private CertificateResolver incomingAnchors;

    public DefaultTrustAnchorResolver() {
    }

    public DefaultTrustAnchorResolver(Collection<X509Certificate> anchors) {
        this(anchors, anchors);
    }

    public DefaultTrustAnchorResolver(Collection<X509Certificate> outgoingAnchors, Collection<X509Certificate> incomingAnchors) {
        this(new UniformCertificateStore(outgoingAnchors), new UniformCertificateStore(incomingAnchors));
    }

    public DefaultTrustAnchorResolver(X509Store anchors) {
        this(anchors, anchors);
    }

    public DefaultTrustAnchorResolver(X509Store outgoingAnchors, X509Store incomingAnchors) {
        this(new UniformCertificateStore(outgoingAnchors), new UniformCertificateStore(incomingAnchors));
    }

    public DefaultTrustAnchorResolver(CertificateResolver anchors) {
        this(anchors, anchors);
    }

    public DefaultTrustAnchorResolver(CertificateResolver outgoingAnchors, CertificateResolver incomingAnchors) {
        if (outgoingAnchors == null || incomingAnchors == null) {
            throw new IllegalArgumentException();
        }
        this.outgoingAnchors = outgoingAnchors;
        this.incomingAnchors = incomingAnchors;
    }

    @Override
    public CertificateResolver getOutgoingAnchors() {
        return this.outgoingAnchors;
    }

    @Override
    public CertificateResolver getIncomingAnchors() {
        return this.incomingAnchors;
    }
}

