/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.mail.internet.InternetAddress;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.policy.PolicyResolver;

public class DomainPolicyResolver
implements PolicyResolver {
    protected Map<String, Collection<PolicyExpression>> incomingPolicies;
    protected Map<String, Collection<PolicyExpression>> outgoingPolicies;

    public DomainPolicyResolver(Map<String, Collection<PolicyExpression>> policies) {
        this.setPolicies(policies, true);
        this.setPolicies(policies, false);
    }

    public DomainPolicyResolver(Map<String, Collection<PolicyExpression>> incomingPolicies, Map<String, Collection<PolicyExpression>> outgoingPolicies) {
        this.setPolicies(incomingPolicies, true);
        this.setPolicies(outgoingPolicies, false);
    }

    public void setPolicies(Map<String, Collection<PolicyExpression>> policies, boolean incoming) {
        Map<String, Collection<PolicyExpression>> toPolicies;
        if (policies == null) {
            throw new IllegalArgumentException("Policies cannot be null");
        }
        if (incoming) {
            toPolicies = this.incomingPolicies = new HashMap<String, Collection<PolicyExpression>>();
        } else {
            this.outgoingPolicies = new HashMap<String, Collection<PolicyExpression>>();
            toPolicies = this.outgoingPolicies;
        }
        for (Map.Entry<String, Collection<PolicyExpression>> entry : policies.entrySet()) {
            toPolicies.put(entry.getKey().toUpperCase(Locale.getDefault()), entry.getValue());
        }
    }

    @Override
    public Collection<PolicyExpression> getOutgoingPolicy(InternetAddress address) {
        return this.getPolicies(address, false);
    }

    @Override
    public Collection<PolicyExpression> getIncomingPolicy(InternetAddress address) {
        return this.getPolicies(address, true);
    }

    protected Collection<PolicyExpression> getPolicies(InternetAddress address, boolean incoming) {
        String domain;
        if (address == null) {
            throw new IllegalArgumentException("Address cannot be null");
        }
        Map<String, Collection<PolicyExpression>> searchPolicies = incoming ? this.incomingPolicies : this.outgoingPolicies;
        Collection<PolicyExpression> retPolocies = searchPolicies.get(domain = NHINDAddress.getHost(address).toUpperCase(Locale.getDefault()));
        if (retPolocies == null) {
            retPolocies = Collections.emptyList();
        }
        return retPolocies;
    }
}

