/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.nhindirect.config.store.Thumbprint;

public class BundleThumbprint {
    private final byte[] digest;
    private final String digestString;

    public static BundleThumbprint toThumbprint(byte[] bytes) throws NoSuchAlgorithmException {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        BundleThumbprint retVal = new BundleThumbprint(bytes);
        return retVal;
    }

    private BundleThumbprint(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(bytes);
        this.digest = md.digest();
        this.digestString = this.createStringRep();
    }

    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    private String createStringRep() {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(this.digest.length * 2);
        for (byte bt : this.digest) {
            buf.append(hexDigits[(bt & 0xF0) >> 4]);
            buf.append(hexDigits[bt & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.digestString;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Thumbprint)) {
            return false;
        }
        BundleThumbprint compareTo = (BundleThumbprint)obj;
        return Arrays.equals(compareTo.digest, this.digest);
    }
}

