/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.TrustBundleAnchor;

@Entity
@Table(name="trustbundle")
public class TrustBundle {
    private long id;
    private String bundleName;
    private String bundleURL;
    private byte[] signingCertificateData;
    private Collection<TrustBundleAnchor> trustBundleAnchors;
    private int refreshInterval = 0;
    private Calendar lastRefreshAttempt;
    private BundleRefreshError lastRefreshError;
    private Calendar lastSuccessfulRefresh;
    private Calendar createTime;
    private String checkSum = "";

    @Id
    @Column(name="id", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Column(name="bundleName", unique=true, nullable=false)
    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    @Column(name="bundleURL", nullable=false)
    public String getBundleURL() {
        return this.bundleURL;
    }

    public void setBundleURL(String bundleURL) {
        this.bundleURL = bundleURL;
    }

    @Column(name="signingCertificateData", length=4096)
    @Lob
    public byte[] getSigningCertificateData() {
        return this.signingCertificateData;
    }

    public void setSigningCertificateData(byte[] signingCertificateData) throws CertificateException {
        this.signingCertificateData = signingCertificateData;
    }

    @Column(name="refreshInterval")
    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    @Column(name="createTime", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar timestamp) {
        this.createTime = timestamp;
    }

    @Column(name="lastSuccessfulRefresh")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getLastSuccessfulRefresh() {
        return this.lastSuccessfulRefresh;
    }

    public void setLastSuccessfulRefresh(Calendar lastSuccessfulRefresh) {
        this.lastSuccessfulRefresh = lastSuccessfulRefresh;
    }

    @Column(name="lastRefreshAttempt")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getLastRefreshAttempt() {
        return this.lastRefreshAttempt;
    }

    public void setLastRefreshAttempt(Calendar lastRefreshAttempt) {
        this.lastRefreshAttempt = lastRefreshAttempt;
    }

    @Column(name="lastRefreshError")
    @Enumerated
    public BundleRefreshError getLastRefreshError() {
        return this.lastRefreshError;
    }

    public void setLastRefreshError(BundleRefreshError lastRefreshError) {
        this.lastRefreshError = lastRefreshError;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY, mappedBy="trustBundle")
    public Collection<TrustBundleAnchor> getTrustBundleAnchors() {
        if (this.trustBundleAnchors == null) {
            this.trustBundleAnchors = new ArrayList<TrustBundleAnchor>();
        }
        return this.trustBundleAnchors;
    }

    public void setTrustBundleAnchors(Collection<TrustBundleAnchor> trustBundleAnchors) {
        this.trustBundleAnchors = trustBundleAnchors;
    }

    @Column(name="getCheckSum", nullable=false)
    public String getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = checkSum;
    }

    public X509Certificate toSigningCertificate() throws CertificateException {
        X509Certificate cert = null;
        try {
            this.validate();
            ByteArrayInputStream bais = new ByteArrayInputStream(this.signingCertificateData);
            cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            bais.close();
        }
        catch (Exception e) {
            throw new CertificateException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return cert;
    }

    public void validate() throws CertificateException {
        if (!this.hasData()) {
            throw new CertificateException("Invalid Certificate: no certificate data exists");
        }
    }

    private boolean hasData() {
        return this.signingCertificateData != null && !this.signingCertificateData.equals(Certificate.NULL_CERT);
    }
}

