/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.dns;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.net.URL;
import org.nhindirect.dns.DNSError;
import org.nhindirect.dns.DNSException;
import org.nhindirect.dns.DNSServer;
import org.nhindirect.dns.DNSServerSettings;
import org.nhindirect.dns.DNSStore;
import org.nhindirect.dns.config.DNSServerConfig;
import org.nhindirect.dns.module.DNSServerConfigModule;

public class DNSServerFactory {
    public static synchronized DNSServer createDNSServer(URL configLocation) throws DNSException {
        return DNSServerFactory.createDNSServer(configLocation, null, null);
    }

    public static synchronized DNSServer createDNSServer(URL configLocation, Provider<DNSStore> dnsStore, Provider<DNSServerSettings> settings) throws DNSException {
        DNSServer retVal = null;
        try {
            Injector agentInjector = DNSServerFactory.buildServerInjector(configLocation, dnsStore, settings);
            retVal = (DNSServer)agentInjector.getInstance(DNSServer.class);
        }
        catch (Exception t) {
            throw new DNSException(DNSError.newError(-1), "DNSServer creation failed: " + t.getMessage(), t);
        }
        return retVal;
    }

    private static Injector buildServerInjector(URL configLocation, Provider<DNSStore> storeProvider, Provider<DNSServerSettings> settings) {
        Injector configInjector = Guice.createInjector((Module[])new Module[]{DNSServerConfigModule.create(configLocation, storeProvider, settings)});
        DNSServerConfig config = (DNSServerConfig)configInjector.getInstance(DNSServerConfig.class);
        return config.getServerInjector();
    }
}

