/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.nhind.config.Certificate;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.EntityStatus;
import org.nhindirect.config.manager.printers.CertRecordPrinter;
import org.nhindirect.config.manager.printers.CertUtils;
import org.nhindirect.config.manager.printers.RecordPrinter;
import org.nhindirect.dns.tools.utils.Command;
import org.nhindirect.dns.tools.utils.StringArrayUtil;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;

public class CertCommands {
    private static final String LIST_CERTIFICATES_USAGE = "Lists certificates in the system";
    private static final String LIST_EMAIL_CERTIFICATES_USAGE = "Lists certificates by a given email address or domain\r\n address\r\n\t address: The email address or domain to search for.  Certificates are mathed on the subject alternative name field of legacy email address of the certificate";
    private static final String IMPORT_PUBLIC_CERT_USAGE = "Imports a certificate that does not contain private key information\r\n  certfile\r\n\t certfile: Fully qualified path and file name of the X509 certificate file.  Place the file name in quotes (\"\") if there are spaces in the path or name.";
    private static final String IMPORT_PRIVATE_CERT_USAGE = "Imports a certificate with a private key an optional passphrase. \r\nFiles should be in pkcs12 format.\r\n  certfile [passphrase]\r\n\t certfile: Fully qualified path and file name of the pkcs12 certificate file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t [passphrase]: Optional passphrase to decrypt the pkcs12 file.";
    private static final String ADD_IPKIX_CERT_USAGE = "Add an IPKIX record with a subject and URL. \r\n\r\n  subject URL\r\n  subject: email address or domain name\r\n\t URL: Fully qualified URL to certificate";
    private static final String REMOVED_CERTIFICATE_USAGE = "Removes a certifacte from the system by owner.\r\n  owner\r\n\t owner: owner or URL of the certificate to be removed";
    protected ConfigurationServiceProxy proxy;
    protected RecordPrinter<Certificate> certPrinter;

    public CertCommands(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
        this.certPrinter = new CertRecordPrinter();
    }

    @Command(name="ListCerts", usage="Lists certificates in the system")
    public void listCerts(String[] args) {
        try {
            Certificate[] certs = this.proxy.listCertificates(1L, 1000, null);
            if (certs == null || certs.length == 0) {
                System.out.println("No certificates found");
            } else {
                this.certPrinter.printRecords(Arrays.asList(certs));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup certificates: " + e.getMessage());
        }
    }

    @Command(name="ListCertsByAddress", usage="Lists certificates by a given email address or domain\r\n address\r\n\t address: The email address or domain to search for.  Certificates are mathed on the subject alternative name field of legacy email address of the certificate")
    public void listCertsByAddress(String[] args) {
        String owner = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            Certificate[] certs = this.proxy.getCertificatesForOwner(owner, null);
            if (certs == null || certs.length == 0) {
                System.out.println("No certificates found");
            } else {
                this.certPrinter.printRecords(Arrays.asList(certs));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup certificates: " + e.getMessage());
        }
    }

    @Command(name="AddPublicCert", usage="Imports a certificate that does not contain private key information\r\n  certfile\r\n\t certfile: Fully qualified path and file name of the X509 certificate file.  Place the file name in quotes (\"\") if there are spaces in the path or name.")
    public void importPublicCert(String[] args) {
        String fileLoc = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            X509Certificate cert = CertUtils.certFromFile(fileLoc);
            Certificate addCert = new Certificate();
            addCert.setData(cert.getEncoded());
            addCert.setOwner(CryptoExtensions.getSubjectAddress((X509Certificate)cert));
            addCert.setPrivateKey(false);
            addCert.setStatus(EntityStatus.ENABLED);
            this.proxy.addCertificates(new Certificate[]{addCert});
            System.out.println("Successfully imported public certificate.");
        }
        catch (IOException e) {
            System.out.println("Error reading file " + fileLoc + " : " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.println("Error importing certificate " + fileLoc + " : " + e.getMessage());
        }
    }

    @Command(name="AddPrivateCert", usage="Imports a certificate with a private key an optional passphrase. \r\nFiles should be in pkcs12 format.\r\n  certfile [passphrase]\r\n\t certfile: Fully qualified path and file name of the pkcs12 certificate file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t [passphrase]: Optional passphrase to decrypt the pkcs12 file.")
    public void importPrivateCert(String[] args) {
        String fileLoc = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String passPhrase = StringArrayUtil.getOptionalValue((String[])args, (int)1, (String)"");
        try {
            byte[] certBytes = FileUtils.readFileToByteArray((File)new File(fileLoc));
            byte[] insertBytes = passPhrase == null || passPhrase.isEmpty() ? certBytes : CertUtils.pkcs12ToStrippedPkcs12(certBytes, passPhrase);
            X509Certificate cert = CertUtils.toX509Certificate(insertBytes);
            Certificate addCert = new Certificate();
            addCert.setData(certBytes);
            addCert.setOwner(CryptoExtensions.getSubjectAddress((X509Certificate)cert));
            addCert.setPrivateKey(cert instanceof X509CertificateEx);
            addCert.setStatus(EntityStatus.ENABLED);
            this.proxy.addCertificates(new Certificate[]{addCert});
            System.out.println("Successfully imported private certificate.");
        }
        catch (IOException e) {
            System.out.println("Error reading file " + fileLoc + " : " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.println("Error importing certificate " + fileLoc + " : " + e.getMessage());
        }
    }

    @Command(name="AddIPKIXCert", usage="Add an IPKIX record with a subject and URL. \r\n\r\n  subject URL\r\n  subject: email address or domain name\r\n\t URL: Fully qualified URL to certificate")
    public void addIPKIXCert(String[] args) {
        String owner = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String URL2 = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        try {
            Certificate addCert = new Certificate();
            addCert.setData(URL2.getBytes());
            addCert.setOwner(owner);
            addCert.setPrivateKey(false);
            addCert.setStatus(EntityStatus.ENABLED);
            this.proxy.addCertificates(new Certificate[]{addCert});
            System.out.println("Successfully added IPKIX certificate URL.");
        }
        catch (Exception e) {
            System.out.println("Error add IPKIX URL: " + e.getMessage());
        }
    }

    @Command(name="RemoveCert", usage="Removes a certifacte from the system by owner.\r\n  owner\r\n\t owner: owner or URL of the certificate to be removed")
    public void removeCert(String[] args) {
        String owner = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            this.proxy.removeCertificatesForOwner(owner);
            System.out.println("Successfully removed certificate for owner." + owner);
        }
        catch (Exception e) {
            System.out.println("Error removing certificate for owner " + owner + " : " + e.getMessage());
        }
    }

    public void setRecordPrinter(RecordPrinter<Certificate> printer) {
        this.certPrinter = printer;
    }

    public void setConfigurationProxy(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
    }
}

