/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.util.ArrayList;
import java.util.Collection;
import org.nhind.config.CertPolicyGroup;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;

public class PolicyGroupPrinter
extends AbstractRecordPrinter<CertPolicyGroup> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList<AbstractRecordPrinter.ReportColumn>();
    protected static final String POLICY_GROUP_NAME_COL = "Policy Group Name";
    protected static final String POLICY_NUMBER_COL = "Number of Policies";

    public PolicyGroupPrinter() {
        super(57, REPORT_COLS);
    }

    @Override
    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, CertPolicyGroup group) {
        try {
            if (column.header.equals(POLICY_NUMBER_COL)) {
                return Integer.toString(group.getCertPolicyGroupReltn() == null ? 0 : group.getCertPolicyGroupReltn().length);
            }
            return super.getColumnValue(column, group);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_GROUP_NAME_COL, 40, "PolicyGroupName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_NUMBER_COL, 16, "Policies"));
    }
}

