/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.tools.policybuild;

import java.awt.BorderLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.nhindirect.policy.tools.policybuild.EditorPanel;

public class SimpleTextPolicyBuilder
extends JFrame {
    private static final long serialVersionUID = -5676575004993173301L;
    protected JMenuBar menuBar;
    protected EditorPanel editPanel;
    protected JMenuItem openFile;
    protected JMenuItem quit;
    protected JMenuItem save;
    protected JMenuItem saveAs;

    public static void main(String[] _args) {
        SimpleTextPolicyBuilder hi = new SimpleTextPolicyBuilder();
        hi.setVisible(true);
    }

    public SimpleTextPolicyBuilder() {
        super("DirectProject SimpleText Policy Builder");
        SimpleTextPolicyBuilder.setDefaultLookAndFeelDecorated(true);
        this.setSize(700, 700);
        Point pt = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(pt.x - 350, pt.y - 350);
        this.enableEvents(64L);
        this.setDefaultCloseOperation(3);
        this.initUI();
        this.addActions();
    }

    private void initUI() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.quit = new JMenuItem("Quit");
        this.save = new JMenuItem("Save");
        this.saveAs = new JMenuItem("SaveAs");
        this.openFile = new JMenuItem("Open");
        fileMenu.add(this.openFile);
        fileMenu.addSeparator();
        fileMenu.add(this.save);
        fileMenu.add(this.saveAs);
        this.menuBar.add(fileMenu);
        this.setJMenuBar(this.menuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.editPanel = new EditorPanel();
        this.getContentPane().add(this.editPanel);
    }

    private void addActions() {
        this.openFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTextPolicyBuilder.this.openPolicyFile();
            }
        });
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTextPolicyBuilder.this.savePolicyFile();
            }
        });
        this.saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTextPolicyBuilder.this.savePolicyFileAs();
            }
        });
    }

    private void openPolicyFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDragEnabled(false);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            this.editPanel.loadFromFile(fc.getSelectedFile());
        }
    }

    private void savePolicyFile() {
        this.editPanel.savePolicyFile();
    }

    private void savePolicyFileAs() {
        this.editPanel.savePolicyFileAs();
    }
}

