/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit.impl;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import java.util.Vector;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.audit.AbstractAuditor;
import org.nhindirect.common.audit.AuditContext;
import org.nhindirect.common.audit.AuditEvent;
import org.nhindirect.common.audit.AuditorMBean;
import org.nhindirect.common.audit.annotation.AuditFile;

public class FileAuditor
extends AbstractAuditor
implements AuditorMBean {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(FileAuditor.class);
    private static final short RECORD_METADATA_SIZE = 36;
    private static final int RECORD_META_WRAPPER = -1;
    private static final DateFormat df = DateFormat.getDateInstance(1, Locale.getDefault());
    private static final String EVENT_ID = "EVENT ID";
    private static final String EVENT_PRINCIPAL = "EVENT PRINCIPAL";
    private static final String EVENT_TIME = "EVENT TIME";
    private static final String EVENT_NAME = "EVENT CATEGORY";
    private static final String EVENT_TYPE = "EVENT MESSAGE";
    private static final String EVENT_CTX = "EVENT CONTEXTS";
    private static final String EVENT_TAG_DELIMITER = "@@@@\r\n";
    private static final String CONTEXT_TAG_DELIMITER = "====\r\n";
    private final RandomAccessFile auditFile;
    private int recordCount;
    private CompositeType eventType;
    private String[] itemNames;

    @Inject
    public FileAuditor(@AuditFile File auditFile) {
        block7: {
            this.recordCount = 0;
            if (auditFile == null) {
                throw new IllegalArgumentException("Audit file cannot be null.");
            }
            LOGGER.info((Object)"Instantiating FileAuditor");
            if (!auditFile.exists()) {
                LOGGER.info((Object)("Audit file does not exist.  Creating new file " + auditFile.getAbsolutePath()));
                try {
                    if (!auditFile.createNewFile()) {
                        throw new IllegalArgumentException("Audit file could not be created.");
                    }
                    break block7;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Audit file could not be created.", e);
                }
            }
            LOGGER.info((Object)("Found existing audit file " + auditFile.getAbsolutePath() + "   Opening in read/write mode."));
        }
        try {
            this.auditFile = new RandomAccessFile(auditFile, "rw");
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Audit file could not be found or created.", e);
        }
        this.initAuditor();
        this.registerMBean();
    }

    private void initAuditor() {
        try {
            if (this.auditFile.length() == 0L) {
                this.recordCount = 0;
                this.auditFile.seek(0L);
            } else {
                boolean foundValidRecord = false;
                boolean needsFixing = false;
                for (long currentPosition = this.auditFile.length(); currentPosition >= 36L && !(foundValidRecord = this.isCurrentRecordValid(currentPosition)); --currentPosition) {
                    if (needsFixing) continue;
                    LOGGER.warn((Object)"Inconsistencies found in audit file.  Attempting to fix issues.  Some data may be lost.");
                    needsFixing = true;
                }
                if (!foundValidRecord) {
                    this.recordCount = 0;
                    this.auditFile.seek(0L);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Audit file is corrupt or could not be read.", e);
        }
    }

    private void registerMBean() {
        LOGGER.info((Object)"Registering FileAuditor MBean");
        try {
            this.itemNames = new String[]{"Event Id", "Event Time", "Event Principal", "Event Name", "Event Type", "Contexts"};
            OpenType[] types = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, ArrayType.getArrayType(SimpleType.STRING)};
            this.eventType = new CompositeType("AuditEvent", "Direct Auditable Event", this.itemNames, this.itemNames, types);
        }
        catch (OpenDataException e) {
            LOGGER.error((Object)("Failed to create settings composite type: " + e.getLocalizedMessage()), (Throwable)e);
            return;
        }
        Class<?> clazz = this.getClass();
        StringBuilder objectNameBuilder = new StringBuilder(clazz.getPackage().getName());
        objectNameBuilder.append(":type=").append(clazz.getSimpleName());
        objectNameBuilder.append(",name=").append(UUID.randomUUID());
        try {
            StandardMBean mbean = new StandardMBean(this, AuditorMBean.class);
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            mbeanServer.registerMBean(mbean, new ObjectName(objectNameBuilder.toString()));
        }
        catch (JMException e) {
            LOGGER.error((Object)"Unable to register the FileAuditor MBean", (Throwable)e);
        }
    }

    private boolean isCurrentRecordValid(long currentFilePosition) throws IOException {
        boolean validRecord = true;
        this.auditFile.seek(currentFilePosition - 36L);
        int start = this.auditFile.readInt();
        int size = this.auditFile.readInt();
        this.recordCount = this.auditFile.readInt();
        byte[] sha1 = new byte[20];
        this.auditFile.read(sha1);
        int end = this.auditFile.readInt();
        boolean bl = validRecord = start == -1 && end == -1;
        if (validRecord) {
            this.auditFile.seek(currentFilePosition - 36L - (long)size);
            byte[] message = new byte[size];
            this.auditFile.read(message);
            byte[] digest = this.generateDigest(message);
            validRecord = Arrays.equals(digest, sha1);
        }
        this.auditFile.seek(currentFilePosition);
        return validRecord;
    }

    private byte[] generateDigest(byte[] message) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(message);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            return new byte[0];
        }
    }

    @Override
    public void writeEvent(UUID eventId, Calendar eventTimeStamp, String principal, AuditEvent event, Collection<? extends AuditContext> contexts) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("Attempting to write new event to the audit store.");
            builder.append("\r\n\t Event Id: ").append(eventId.toString());
            builder.append("\r\n\t Event Time: ").append(df.format(eventTimeStamp.getTime()));
            builder.append("\r\n\t Event Principal: ").append(principal);
            builder.append("\r\n\t Event Name: ").append(event.getName());
            builder.append("\r\n\t Event Type: ").append(event.getType());
            LOGGER.trace((Object)builder.toString());
        }
        String recordText = this.buildRecordText(eventId, eventTimeStamp, principal, event, contexts);
        byte[] messageBytes = recordText.getBytes();
        byte[] sha1 = this.generateDigest(messageBytes);
        try {
            this.auditFile.writeInt(messageBytes.length);
            this.auditFile.write(messageBytes);
            this.auditFile.writeInt(-1);
            this.auditFile.writeInt(messageBytes.length);
            this.auditFile.writeInt(++this.recordCount);
            this.auditFile.write(sha1);
            this.auditFile.writeInt(-1);
        }
        catch (IOException e) {
            throw new IllegalStateException("The audit file cannot be written to.", e);
        }
    }

    private String buildRecordText(UUID eventId, Calendar eventTimeStamp, String principal, AuditEvent event, Collection<? extends AuditContext> contexts) {
        StringBuilder builder = new StringBuilder();
        builder.append("\r\nEVENT ID: " + eventId + EVENT_TAG_DELIMITER);
        builder.append("\tEVENT TIME: " + df.format(eventTimeStamp.getTime()) + EVENT_TAG_DELIMITER);
        builder.append("\tEVENT PRINCIPAL: " + principal + EVENT_TAG_DELIMITER);
        builder.append("\tEVENT CATEGORY: " + event.getName() + EVENT_TAG_DELIMITER);
        builder.append("\tEVENT MESSAGE: " + event.getType() + EVENT_TAG_DELIMITER);
        if (contexts != null && contexts.size() > 0) {
            builder.append("\tEVENT CONTEXTS====\r\n");
            for (AuditContext auditContext : contexts) {
                builder.append("\t\t" + auditContext.getContextName() + ":" + auditContext.getContextValue() + CONTEXT_TAG_DELIMITER);
            }
            builder.append(EVENT_TAG_DELIMITER);
        }
        builder.append("\r\n");
        return builder.toString();
    }

    @Override
    public synchronized Integer getEventCount() {
        return this.recordCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompositeData[] getEvents(Integer eventCount) {
        if (this.eventType == null || eventCount == 0) {
            return null;
        }
        Vector<CompositeData> retVal = new Vector<CompositeData>();
        long savePosition = -1L;
        try {
            long currentPosition = savePosition = this.auditFile.getFilePointer();
            CompositeData event = this.getLastEvent();
            if (event != null) {
                retVal.add(event);
            }
            for (int cnt = 1; cnt < eventCount && event != null; ++cnt) {
                int size = this.getRecordSize(currentPosition);
                this.auditFile.seek(currentPosition -= (long)(36 + size + 4));
                event = this.getLastEvent();
                if (event == null) continue;
                retVal.add(event);
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (savePosition > -1L) {
                    this.auditFile.seek(savePosition);
                }
            }
            catch (IOException e) {}
        }
        return retVal.size() > 0 ? retVal.toArray(new CompositeData[retVal.size()]) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized CompositeData getLastEvent() {
        if (this.eventType == null) {
            return null;
        }
        CompositeData retVal = null;
        long currentPosition = -1L;
        try {
            currentPosition = this.auditFile.getFilePointer();
            retVal = this.getEvent(currentPosition);
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (currentPosition > -1L) {
                    this.auditFile.seek(currentPosition);
                }
            }
            catch (IOException e) {}
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecordSize(long position) {
        int retVal = -1;
        try {
            long currentPosition = position;
            if (this.recordCount > 0 && currentPosition >= 36L) {
                this.auditFile.seek(currentPosition - 36L);
                this.auditFile.readInt();
                retVal = this.auditFile.readInt();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                this.auditFile.seek(position);
            }
            catch (IOException e) {}
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeData getEvent(long position) {
        CompositeDataSupport retVal = null;
        try {
            int size;
            long currentPosition = position;
            if (this.recordCount > 0 && currentPosition >= 36L && (size = this.getRecordSize(position)) > 0) {
                this.auditFile.seek(currentPosition - 36L - (long)size);
                byte[] message = new byte[size];
                this.auditFile.read(message);
                String strMessage = new String(message);
                String[] eventTags = strMessage.split(EVENT_TAG_DELIMITER);
                String id = "";
                String time = "";
                String principal = "";
                String name = "";
                String type = "";
                String[] contexts = null;
                for (String tag : eventTags) {
                    String[] ctx;
                    if ((tag = tag.trim()).startsWith(EVENT_ID)) {
                        id = this.getItemText(tag);
                        continue;
                    }
                    if (tag.startsWith(EVENT_TIME)) {
                        time = this.getItemText(tag);
                        continue;
                    }
                    if (tag.startsWith(EVENT_PRINCIPAL)) {
                        principal = this.getItemText(tag);
                        continue;
                    }
                    if (tag.startsWith(EVENT_NAME)) {
                        name = this.getItemText(tag);
                        continue;
                    }
                    if (tag.startsWith(EVENT_TYPE)) {
                        type = this.getItemText(tag);
                        continue;
                    }
                    if (!tag.startsWith(EVENT_CTX) || (ctx = (tag = tag + "\r\n").split(CONTEXT_TAG_DELIMITER)).length <= 1) continue;
                    contexts = new String[ctx.length - 1];
                    for (int i = 1; i < ctx.length; ++i) {
                        contexts[i - 1] = ctx[i].trim();
                    }
                }
                if (contexts == null) {
                    contexts = new String[]{" "};
                }
                Object[] eventValues = new Object[]{id, time, principal, name, type, contexts};
                try {
                    retVal = new CompositeDataSupport(this.eventType, this.itemNames, eventValues);
                }
                catch (OpenDataException e) {
                    LOGGER.error((Object)"Error create composit data for audit event.", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error reading audit file to create audit event composite data.", (Throwable)e);
        }
        finally {
            try {
                this.auditFile.seek(position);
            }
            catch (IOException e) {}
        }
        return retVal;
    }

    private String getItemText(String item) {
        int index = item.indexOf(":");
        if (index > -1) {
            return item.substring(index + 1).trim();
        }
        return "";
    }

    @Override
    public synchronized void clear() {
        try {
            this.auditFile.setLength(0L);
            this.auditFile.seek(0L);
            this.recordCount = 0;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

