/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.nhindirect.config.manager.printers.RecordPrinter;

public abstract class AbstractRecordPrinter<T>
implements RecordPrinter<T> {
    protected final Collection<ReportColumn> reportColumns;
    protected final int tableWidth;

    public AbstractRecordPrinter(int tableWidth, Collection<ReportColumn> reportColumns) {
        this.tableWidth = tableWidth;
        this.reportColumns = reportColumns;
    }

    @Override
    public void printRecord(T record) {
        this.printRecords(Arrays.asList(record));
    }

    @Override
    public void printRecords(Collection<T> records) {
        this.printHeader();
        for (T record : records) {
            this.printRecordInternal(record);
        }
    }

    protected void printRecordInternal(T record) {
        StringBuilder builder = new StringBuilder();
        int cnt = 0;
        for (ReportColumn column : this.reportColumns) {
            builder.append("  ");
            String colValue = this.getColumnValue(column, record);
            builder.append(colValue);
            int padSize = column.width - 2 - colValue.length();
            for (int i = 0; i < padSize; ++i) {
                builder.append(' ');
            }
            if (++cnt >= this.reportColumns.size()) continue;
            builder.append("|");
        }
        builder.append("\r\n");
        for (int i = 0; i < this.tableWidth; ++i) {
            builder.append('-');
        }
        System.out.println(builder.toString());
    }

    protected String getColumnValue(ReportColumn column, T record) {
        try {
            Method method = record.getClass().getDeclaredMethod("get" + column.fieldName, new Class[0]);
            Object obj = method.invoke(record, new Object[0]);
            return obj.toString();
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    protected void printHeader() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.tableWidth; ++i) {
            builder.append('-');
        }
        builder.append("\r\n|");
        int cnt = 0;
        int widthUsed = 0;
        for (ReportColumn column : this.reportColumns) {
            int i;
            int currentWidth = 0;
            currentWidth = ++cnt >= this.reportColumns.size() ? this.tableWidth - widthUsed : column.width;
            int padding = (currentWidth - column.header.length()) / 2;
            for (i = 0; i < padding; ++i) {
                builder.append(' ');
            }
            builder.append(column.header);
            for (i = 0; i < padding - 1; ++i) {
                builder.append(' ');
            }
            builder.append("|");
            widthUsed += currentWidth;
        }
        builder.append("\r\n");
        for (int i = 0; i < this.tableWidth; ++i) {
            builder.append('-');
        }
        System.out.println(builder.toString());
    }

    protected static class ReportColumn {
        protected final String header;
        protected final int width;
        protected final String fieldName;

        public ReportColumn(String header, int width, String fieldName) {
            this.header = header;
            this.width = width;
            this.fieldName = fieldName;
        }
    }
}

