/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.audit;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import org.nhindirect.common.audit.Auditor;
import org.nhindirect.common.audit.module.ProviderAuditorModule;
import org.nhindirect.common.audit.provider.LoggingAuditorProvider;
import org.nhindirect.common.audit.provider.SPIAuditorProvider;

public class AuditorFactory {
    public static synchronized Auditor createAuditor() {
        SPIAuditorProvider spiProv = new SPIAuditorProvider();
        Object provider = spiProv.isImplementationAvailable() ? spiProv : new LoggingAuditorProvider();
        return AuditorFactory.createAuditor(provider);
    }

    public static synchronized Auditor createAuditor(Provider<Auditor> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Provider cannot be null.");
        }
        ProviderAuditorModule module = ProviderAuditorModule.create(provider);
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add((Module)module);
        return AuditorFactory.createAuditor(modules);
    }

    public static synchronized Auditor createAuditor(Collection<Module> modules) {
        if (modules == null || modules.size() == 0) {
            throw new IllegalArgumentException("Modules cannot be null or empty");
        }
        Injector configInjector = Guice.createInjector(modules);
        return (Auditor)configInjector.getInstance(Auditor.class);
    }
}

