/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.crypto.MutableKeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.exceptions.CryptoException;
import sun.security.pkcs11.SunPKCS11;

public abstract class AbstractPKCS11TokenKeyStoreProtectionManager
implements MutableKeyStoreProtectionManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(AbstractPKCS11TokenKeyStoreProtectionManager.class);
    protected static final String SUNPKCS11_KEYSTORE_PROVIDER_NAME = "sun.security.pkcs11.SunPKCS11";
    protected static final String DEFAULT_KESTORE_TYPE = "PKCS11";
    protected PKCS11Credential credential;
    protected String keyStorePassPhraseAlias;
    protected String privateKeyPassPhraseAlias;
    protected KeyStore ks;
    protected String keyStoreType;
    protected String keyStoreProviderName;
    protected String pcks11ConfigFile;
    protected InputStream keyStoreSource;

    public AbstractPKCS11TokenKeyStoreProtectionManager() throws CryptoException {
        this.credential = null;
        this.keyStorePassPhraseAlias = "";
        this.privateKeyPassPhraseAlias = "";
        this.keyStoreType = DEFAULT_KESTORE_TYPE;
        this.keyStoreProviderName = "";
        this.pcks11ConfigFile = "";
        this.keyStoreSource = null;
    }

    public AbstractPKCS11TokenKeyStoreProtectionManager(PKCS11Credential credential, String keyStorePassPhraseAlias, String privateKeyPassPhraseAlias) throws CryptoException {
        this.credential = credential;
        this.keyStorePassPhraseAlias = keyStorePassPhraseAlias;
        this.privateKeyPassPhraseAlias = privateKeyPassPhraseAlias;
        this.keyStoreType = DEFAULT_KESTORE_TYPE;
        this.keyStoreProviderName = "";
        this.pcks11ConfigFile = "";
        this.keyStoreSource = null;
        this.initTokenStore();
    }

    protected void loadProvider() throws CryptoException {
        try {
            if (!StringUtils.isEmpty((String)this.keyStoreProviderName)) {
                if (this.keyStoreProviderName.equals(SUNPKCS11_KEYSTORE_PROVIDER_NAME)) {
                    if (StringUtils.isEmpty((String)this.pcks11ConfigFile)) {
                        throw new IllegalStateException("SunPKCS11 providers require a configuration file.  There is not one set.");
                    }
                    FileInputStream inStream = FileUtils.openInputStream((File)new File(this.pcks11ConfigFile));
                    Properties props = new Properties();
                    props.load(inStream);
                    IOUtils.closeQuietly((InputStream)inStream);
                    boolean providerFound = false;
                    String requestedName = props.getProperty("name");
                    if (!StringUtils.isEmpty((String)requestedName) && Security.getProvider(requestedName) != null) {
                        providerFound = true;
                    }
                    if (!providerFound) {
                        Security.addProvider(new SunPKCS11(this.pcks11ConfigFile));
                    }
                } else {
                    Class<?> provider = this.getClass().getClassLoader().loadClass(this.keyStoreProviderName);
                    boolean providerFound = false;
                    for (Provider existingProv : Security.getProviders()) {
                        if (!existingProv.getClass().equals(provider)) continue;
                        providerFound = true;
                        break;
                    }
                    if (!providerFound) {
                        Security.addProvider((Provider)provider.newInstance());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CryptoException("Error loading PKCS11 provder", e);
        }
    }

    public void setCredential(PKCS11Credential credential) {
        this.credential = credential;
    }

    public void setKeyStorePassPhraseAlias(String keyStorePassPhraseAlias) {
        this.keyStorePassPhraseAlias = keyStorePassPhraseAlias;
    }

    public void setPrivateKeyPassPhraseAlias(String privateKeyPassPhraseAlias) {
        this.privateKeyPassPhraseAlias = privateKeyPassPhraseAlias;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setKeyStoreSource(InputStream keyStoreSource) {
        this.keyStoreSource = keyStoreSource;
    }

    public void setKeyStoreSourceAsString(String keyStoreSource) {
        try {
            this.keyStoreSource = new ByteArrayInputStream(keyStoreSource.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setKeyStoreProviderName(String keyStoreProviderName) {
        this.keyStoreProviderName = keyStoreProviderName;
    }

    public void setPcks11ConfigFile(String pcks11ConfigFile) {
        this.pcks11ConfigFile = pcks11ConfigFile;
    }

    public abstract void initTokenStore() throws CryptoException;

    @Override
    public synchronized Map<String, Key> getAllKeys() throws CryptoException {
        HashMap<String, Key> keys = new HashMap<String, Key>();
        try {
            Enumeration<String> aliases = this.ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.ks.isKeyEntry(alias)) continue;
                try {
                    Key key = this.ks.getKey(alias, null);
                    if (!(key instanceof SecretKey)) continue;
                    keys.put(alias, key);
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            throw new CryptoException("Error extracting private key protection from PKCS11 token", e);
        }
        return keys;
    }

    @Override
    public Key getKey(String keyName) throws CryptoException {
        return this.safeGetKeyWithRetry(keyName);
    }

    @Override
    public Key getPrivateKeyProtectionKey() throws CryptoException {
        return this.safeGetKeyWithRetry(this.privateKeyPassPhraseAlias);
    }

    @Override
    public Key getKeyStoreProtectionKey() throws CryptoException {
        return this.safeGetKeyWithRetry(this.keyStorePassPhraseAlias);
    }

    @Override
    public void setPrivateKeyProtectionKey(Key key) throws CryptoException {
        this.safeSetKeyWithRetry(this.privateKeyPassPhraseAlias, key);
    }

    @Override
    public void setPrivateKeyProtectionKeyAsBytes(byte[] key) throws CryptoException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "");
            this.safeSetKeyWithRetry(this.privateKeyPassPhraseAlias, keySpec);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("Error storing key store protection into PKCS11 token", e);
        }
    }

    @Override
    public void setPrivateKeyProtectionKeyAsString(String key) throws CryptoException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "");
            this.safeSetKeyWithRetry(this.privateKeyPassPhraseAlias, keySpec);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("Error storing key store protection into PKCS11 token", e);
        }
    }

    @Override
    public void clearPrivateKeyProtectionKey() throws CryptoException {
        this.safeDeleteKeyWithRetry(this.privateKeyPassPhraseAlias);
    }

    @Override
    public void setKeyStoreProtectionKey(Key key) throws CryptoException {
        this.safeSetKeyWithRetry(this.keyStorePassPhraseAlias, key);
    }

    @Override
    public void setKeyStoreProtectionKeyAsBytes(byte[] key) throws CryptoException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, "");
            this.safeSetKeyWithRetry(this.keyStorePassPhraseAlias, keySpec);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("Error storing key store protection into PKCS11 token", e);
        }
    }

    @Override
    public void setKeyStoreProtectionKeyAsString(String key) throws CryptoException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "");
            this.safeSetKeyWithRetry(this.keyStorePassPhraseAlias, keySpec);
        }
        catch (CryptoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CryptoException("Error storing key store protection into PKCS11 token", e);
        }
    }

    @Override
    public void clearKeyStoreProtectionKey() throws CryptoException {
        this.safeDeleteKeyWithRetry(this.keyStorePassPhraseAlias);
    }

    @Override
    public void setKey(String alias, Key key) throws CryptoException {
        this.safeSetKeyWithRetry(alias, key);
    }

    @Override
    public void clearKey(String alias) throws CryptoException {
        if (this.getKey(alias) != null) {
            this.safeDeleteKeyWithRetry(alias);
        }
    }

    protected synchronized void safeSetKeyWithRetry(String alias, Key key) throws CryptoException {
        boolean reloadAndRetry = false;
        try {
            this.ks.setKeyEntry(alias, key, null, null);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not set key entry on first attemp.  Will attempt to reload the key store and try again");
            reloadAndRetry = true;
        }
        if (reloadAndRetry) {
            this.reloadKeyStore();
            try {
                this.ks.setKeyEntry(alias, key, null, null);
            }
            catch (Exception e) {
                throw new CryptoException("Error setting key in PKCS11 token", e);
            }
        }
    }

    protected synchronized void safeDeleteKeyWithRetry(String alias) throws CryptoException {
        boolean reloadAndRetry = false;
        try {
            this.ks.deleteEntry(alias);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not delete key entry on first attemp.  Will attempt to reload the key store and try again");
            reloadAndRetry = true;
        }
        if (reloadAndRetry) {
            this.reloadKeyStore();
            try {
                this.ks.deleteEntry(alias);
            }
            catch (Exception e) {
                throw new CryptoException("Error deleting key from PKCS11 token", e);
            }
        }
    }

    protected synchronized Key safeGetKeyWithRetry(String alias) throws CryptoException {
        boolean reloadAndRetry = false;
        try {
            return this.ks.getKey(alias, null);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Could not get key entry on first attemp.  Will attempt to reload the key store and try again");
            reloadAndRetry = true;
            if (reloadAndRetry) {
                this.reloadKeyStore();
                try {
                    return this.ks.getKey(alias, null);
                }
                catch (Exception e2) {
                    throw new CryptoException("Error getting key from PKCS11 token", e2);
                }
            }
            return null;
        }
    }

    protected void reloadKeyStore() throws CryptoException {
        this.ks = null;
        this.initTokenStore();
    }
}

