/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.crypto.impl;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.exceptions.CryptoException;

public class BootstrappedKeyStoreProtectionManager
implements KeyStoreProtectionManager {
    protected Key keyStoreProtectionKey;
    protected Key privateKeyProtectionKey;

    public BootstrappedKeyStoreProtectionManager() {
    }

    public BootstrappedKeyStoreProtectionManager(String keyStoreProtectionKey, String privateKeyProtectionKey) {
        this.setKeyStoreProtectionKey(keyStoreProtectionKey);
        this.setPrivateKeyProtectionKey(privateKeyProtectionKey);
    }

    public void setKeyStoreProtectionKey(byte[] keyStoreProtectionKey) {
        this.keyStoreProtectionKey = new SecretKeySpec(keyStoreProtectionKey, "");
    }

    public void setKeyStoreProtectionKey(String keyStoreProtectionKey) {
        this.keyStoreProtectionKey = new SecretKeySpec(keyStoreProtectionKey.getBytes(), "");
    }

    public void setPrivateKeyProtectionKey(byte[] privateKeyProtectionKey) {
        this.privateKeyProtectionKey = new SecretKeySpec(privateKeyProtectionKey, "");
    }

    public void setPrivateKeyProtectionKey(String privateKeyProtectionKey) {
        this.privateKeyProtectionKey = new SecretKeySpec(privateKeyProtectionKey.getBytes(), "");
    }

    @Override
    public Key getPrivateKeyProtectionKey() throws CryptoException {
        return this.privateKeyProtectionKey;
    }

    @Override
    public Key getKeyStoreProtectionKey() throws CryptoException {
        return this.keyStoreProtectionKey;
    }

    @Override
    public Map<String, Key> getAllKeys() throws CryptoException {
        HashMap<String, Key> keys = new HashMap<String, Key>();
        keys.put("PrivKeyProtKey", this.getPrivateKeyProtectionKey());
        keys.put("KeyStoreProtKey", this.getKeyStoreProtectionKey());
        return keys;
    }

    @Override
    public Key getKey(String keyName) throws CryptoException {
        return null;
    }
}

