/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.nhindirect.common.rest.SecuredServiceRequestBase;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.ServiceException;

public abstract class AbstractGetRequest<T>
extends SecuredServiceRequestBase<Collection<T>, ServiceException> {
    protected final boolean collectionRequest;

    protected AbstractGetRequest(HttpClient httpClient, String serviceUrl, ObjectMapper jsonMapper, ServiceSecurityManager securityManager, boolean collectionRequest) {
        super(httpClient, serviceUrl, jsonMapper, securityManager);
        this.collectionRequest = collectionRequest;
    }

    protected abstract String getRequestUri() throws ServiceException;

    @Override
    protected Collection<T> interpretResponse(int statusCode, HttpResponse response) throws IOException, ServiceException {
        switch (statusCode) {
            case 200: {
                return (Collection)super.interpretResponse(statusCode, response);
            }
            case 204: 
            case 404: {
                return Collections.emptyList();
            }
        }
        return (Collection)super.interpretResponse(statusCode, response);
    }

    @Override
    protected final HttpUriRequest createRequest() throws IOException {
        try {
            HttpGet get = new HttpGet(this.getRequestUri());
            return get;
        }
        catch (ServiceException e) {
            throw new IOException("Error creating request.", e);
        }
    }

    @Override
    protected List<T> parseResponse(HttpEntity response) throws IOException {
        List<Object> retVal;
        Class persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (this.collectionRequest) {
            retVal = (List<Object>)this.jsonMapper.readValue(response.getContent(), TypeFactory.collectionType(ArrayList.class, (Class)persistentClass));
        } else {
            Object single = this.jsonMapper.readValue(response.getContent(), persistentClass);
            retVal = Arrays.asList(single);
        }
        return retVal;
    }
}

