/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest;

import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.map.ObjectMapper;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.UnsecuredServiceRequestBase;
import org.nhindirect.common.rest.exceptions.ServiceException;

public abstract class SecuredServiceRequestBase<T, E extends Exception>
extends UnsecuredServiceRequestBase<T, E> {
    protected final ServiceSecurityManager securityManager;

    public SecuredServiceRequestBase(HttpClient httpClient, String serviceUrl, ObjectMapper jsonMapper, ServiceSecurityManager securityManager) {
        super(httpClient, serviceUrl, jsonMapper);
        if (securityManager == null) {
            throw new IllegalArgumentException("Security manager cannot be null");
        }
        this.securityManager = securityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T call() throws E, IOException, ServiceException {
        HttpUriRequest request = this.createRequest();
        assert (request != null);
        request = this.securityManager.createAuthenticatedRequest(request);
        HttpResponse response = this.httpClient.execute(request);
        try {
            int statusCode = response.getStatusLine().getStatusCode();
            Object t = this.interpretResponse(statusCode, response);
            return t;
        }
        finally {
            SecuredServiceRequestBase.closeConnection(response);
        }
    }
}

