/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.common.rest.auth.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.nhindirect.common.rest.auth.BasicAuthCredential;
import org.nhindirect.common.rest.auth.BasicAuthCredentialStore;
import org.nhindirect.common.rest.auth.impl.DefaultBasicAuthCredential;

public class BootstrapBasicAuthCredentialStore
implements BasicAuthCredentialStore {
    protected Map<String, BasicAuthCredential> credentialMap = new HashMap<String, BasicAuthCredential>();

    public BootstrapBasicAuthCredentialStore() {
    }

    public BootstrapBasicAuthCredentialStore(List<BasicAuthCredential> credentials) {
        this();
        this.setCredentails(credentials);
    }

    public void setCredentails(List<BasicAuthCredential> credentials) {
        for (BasicAuthCredential cred : credentials) {
            this.credentialMap.put(cred.getUser().toUpperCase(Locale.getDefault()), cred);
        }
    }

    public void setCredentialsAsDelimetedString(List<String> credentials) {
        for (String str : credentials) {
            String[] parsedStr = str.split(",");
            DefaultBasicAuthCredential cred = new DefaultBasicAuthCredential(parsedStr[0], parsedStr[1], parsedStr[2]);
            this.credentialMap.put(cred.getUser().toUpperCase(Locale.getDefault()), cred);
        }
    }

    public void setCredentialsAsProperties(Properties credentials) {
        for (Map.Entry<Object, Object> entry : credentials.entrySet()) {
            String[] parsedStr = entry.getValue().toString().split(",");
            DefaultBasicAuthCredential cred = new DefaultBasicAuthCredential(parsedStr[0], parsedStr[1], parsedStr[2]);
            this.credentialMap.put(cred.getUser().toUpperCase(Locale.getDefault()), cred);
        }
    }

    @Override
    public BasicAuthCredential getCredential(String name) {
        return this.credentialMap.get(name.toUpperCase(Locale.getDefault()));
    }
}

