/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhind.config.CertPolicy;
import org.nhind.config.CertPolicyGroup;
import org.nhind.config.CertPolicyGroupDomainReltn;
import org.nhind.config.CertPolicyGroupReltn;
import org.nhind.config.CertPolicyUse;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Domain;
import org.nhind.config.PolicyLexicon;
import org.nhindirect.config.manager.printers.PolicyGroupPrinter;
import org.nhindirect.config.manager.printers.PolicyPrinter;
import org.nhindirect.config.manager.printers.PolicyUsagePrinter;
import org.nhindirect.dns.tools.utils.Command;
import org.nhindirect.dns.tools.utils.StringArrayUtil;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyParseException;

public class PolicyCommands {
    private static final String LIST_POLICIES_USAGE = "Lists policies in the system";
    private static final String IMPORT_POLICY_USAGE = "Imports a policy from a file with an optional lexicon definition.\r\n  policyName policyDefFile [lexicon]\r\n\t policyName: Name of the policy.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t policyDefFile: Fully qualified path and file name of the policy definition file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t [lexicon]: Optional lexicon of the policy definition.  Default to SIMPLE_TEXT_V1 if not supplied.";
    private static final String DELETE_POLICY_USAGE = "Deletes a policy from the system by policy name.\r\n  policyName \r\n\t policyName: Name of the policy.  Place the policy name in quotes (\"\") if there are spaces in the name.";
    private static final String LIST_POLICY_GROUPS_USAGE = "Lists policy groups in the system";
    private static final String ADD_POLICY_GROUP_USAGE = "Adds policy group to the system\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.";
    private static final String DELETE_POLICY_GROUP_USAGE = "Deletes a policy group from the system by policy group name.\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.";
    private static final String LIST_GROUP_POLICIES_USAGE = "List policies and usage within a policy group.\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.";
    private static final String ADD_POLICY_TO_GROUP_USAGE = "Adds an existing policy to a group with a provided usage.\r\n  policyName groupNames policyUse incoming outgoing\r\n\t policyName: Name of the policy to add to the group.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t groupName: Name of the policy group to add the policy to.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t policyUse: Usage name of the policy in the group.  Must be one of the following values: TRUST, PRIVATE_RESOLVER, PUBLIC_RESOLVER.\r\n\t incoming: Indicates if policy is used for incoming messages.  Must be one of the following values: true, false\r\n\t outgoing: Indicates if policy is used for outgoing messages.  Must be one of the following values: true, false";
    private static final String DELETE_POLICY_FROM_GROUP_USAGE = "Deletes an existing policy from a group.\r\n  policyName groupName\r\n\t policyName: Name of the policy to delete from the group.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t groupName: Name of the policy group to delete the policy from.  Place the policy group name in quotes (\"\") if there are spaces in the name.";
    private static final String LIST_DOMAIN_POLICY_GROUPS = "List policy groups within a domain\r\n  domainName\r\n\t domainName: Name of the domain.";
    private static final String ADD_GROUP_TO_DOMAIN_USAGE = "Adds an existing policy group to an existing domain.\r\n  groupName domainName\r\n\t groupName: Name of the policy group to add to the domain.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t domainName: Name of the domain to add the group to.";
    private static final String DELETE_GROUP_FROM_DOMAIN_USAGE = "Deletes an existing policy group from a domain.\r\n  groupName domainName \r\n\t groupName: Name of the policy group to delete from the domain.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t domainName: Name of the domain to delete the policy group from.";
    protected ConfigurationServiceProxy proxy;
    protected final PolicyPrinter policyPrinter;
    protected final PolicyGroupPrinter groupPrinter;
    protected final PolicyUsagePrinter policyUsagePrinter;

    public PolicyCommands(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
        this.policyPrinter = new PolicyPrinter();
        this.groupPrinter = new PolicyGroupPrinter();
        this.policyUsagePrinter = new PolicyUsagePrinter();
    }

    @Command(name="ListPolicies", usage="Lists policies in the system")
    public void listPolicies(String[] args) {
        try {
            CertPolicy[] policies = this.proxy.getPolicies();
            if (policies == null || policies.length == 0) {
                System.out.println("No policies found");
            } else {
                this.policyPrinter.printRecords(Arrays.asList(policies));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policies: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Command(name="ImportPolicy", usage="Imports a policy from a file with an optional lexicon definition.\r\n  policyName policyDefFile [lexicon]\r\n\t policyName: Name of the policy.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t policyDefFile: Fully qualified path and file name of the policy definition file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t [lexicon]: Optional lexicon of the policy definition.  Default to SIMPLE_TEXT_V1 if not supplied.")
    public void importPolicy(String[] args) {
        byte[] policyBytes;
        PolicyLexicon lex;
        String policyName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String fileLoc = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        String lexicon = StringArrayUtil.getOptionalValue((String[])args, (int)2, (String)"");
        try {
            CertPolicy policy = this.proxy.getPolicyByName(policyName);
            if (policy != null) {
                System.out.println("Policy with name " + policyName + " already exists.");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy: " + e.getMessage());
            return;
        }
        if (lexicon.isEmpty()) {
            lex = PolicyLexicon.SIMPLE_TEXT_V1;
        } else {
            try {
                lex = PolicyLexicon.fromString((String)lexicon);
            }
            catch (Exception e) {
                System.out.println("Invalid lexicon name.");
                return;
            }
        }
        org.nhindirect.policy.PolicyLexicon parseLexicon = lex.equals((Object)PolicyLexicon.JAVA_SER) ? org.nhindirect.policy.PolicyLexicon.JAVA_SER : (lex.equals((Object)PolicyLexicon.SIMPLE_TEXT_V1) ? org.nhindirect.policy.PolicyLexicon.SIMPLE_TEXT_V1 : org.nhindirect.policy.PolicyLexicon.XML);
        ByteArrayInputStream inStr = null;
        try {
            policyBytes = FileUtils.readFileToByteArray((File)new File(fileLoc));
            inStr = new ByteArrayInputStream(policyBytes);
            PolicyLexiconParser parser = PolicyLexiconParserFactory.getInstance((org.nhindirect.policy.PolicyLexicon)parseLexicon);
            parser.parse((InputStream)inStr);
        }
        catch (PolicyParseException e) {
            System.out.println("Syntax error in policy file " + fileLoc + " : " + e.getMessage());
            IOUtils.closeQuietly((InputStream)inStr);
            return;
        }
        catch (IOException e) {
            System.out.println("Error reading file " + fileLoc + " : " + e.getMessage());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStr);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inStr);
            return;
        }
        IOUtils.closeQuietly((InputStream)inStr);
        try {
            CertPolicy addPolicy = new CertPolicy();
            addPolicy.setPolicyData(policyBytes);
            addPolicy.setPolicyName(policyName);
            addPolicy.setLexicon(lex);
            this.proxy.addPolicy(addPolicy);
            System.out.println("Successfully imported policy.");
        }
        catch (IOException e) {
            System.out.println("Error reading file " + fileLoc + " : " + e.getMessage());
            return;
        }
        catch (Exception e) {
            System.out.println("Error importing certificate " + fileLoc + " : " + e.getMessage());
        }
    }

    @Command(name="DeletePolicy", usage="Deletes a policy from the system by policy name.\r\n  policyName \r\n\t policyName: Name of the policy.  Place the policy name in quotes (\"\") if there are spaces in the name.")
    public void deletePolicy(String[] args) {
        String policyName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        CertPolicy policy = null;
        try {
            policy = this.proxy.getPolicyByName(policyName);
            if (policy == null) {
                System.out.println("No policy with name " + policyName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy: " + e.getMessage());
            return;
        }
        try {
            this.proxy.deletePolicies(new Long[]{policy.getId()});
            System.out.println("Policy successfully deleted");
        }
        catch (Exception e) {
            System.out.println("Failed to delete policy: " + e.getMessage());
            return;
        }
    }

    @Command(name="ListPolicyGroups", usage="Lists policy groups in the system")
    public void listPolicyGroups(String[] args) {
        try {
            CertPolicyGroup[] groups = this.proxy.getPolicyGroups();
            if (groups == null || groups.length == 0) {
                System.out.println("No policy groups found");
            } else {
                this.groupPrinter.printRecords(Arrays.asList(groups));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policies: " + e.getMessage());
        }
    }

    @Command(name="AddPolicyGroup", usage="Adds policy group to the system\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.")
    public void addPolicyGroup(String[] args) {
        CertPolicyGroup policyGroup;
        String policyGroupName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            policyGroup = this.proxy.getPolicyGroupByName(policyGroupName);
            if (policyGroup != null) {
                System.out.println("Policy group with name " + policyGroupName + " already exists.");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy: " + e.getMessage());
            return;
        }
        try {
            policyGroup = new CertPolicyGroup();
            policyGroup.setPolicyGroupName(policyGroupName);
            this.proxy.addPolicyGroup(policyGroup);
            System.out.println("Successfully added policy group.");
        }
        catch (Exception e) {
            System.out.println("Failed to add policy group: " + e.getMessage());
            return;
        }
    }

    @Command(name="DeletePolicyGroup", usage="Deletes a policy group from the system by policy group name.\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.")
    public void deletePolicyGroup(String[] args) {
        String policyGroupName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        CertPolicyGroup group = null;
        try {
            group = this.proxy.getPolicyGroupByName(policyGroupName);
            if (group == null) {
                System.out.println("No policy group with name " + policyGroupName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy group: " + e.getMessage());
            return;
        }
        try {
            this.proxy.deletePolicyGroups(new Long[]{group.getId()});
            System.out.println("Policy groups successfully deleted");
        }
        catch (Exception e) {
            System.out.println("Failed to delete policy group: " + e.getMessage());
            return;
        }
    }

    @Command(name="ListGroupPolicies", usage="List policies and usage within a policy group.\r\n  groupName \r\n\t groupName: Name of the policy group.  Place the policy group name in quotes (\"\") if there are spaces in the name.")
    public void listGroupPolicies(String[] args) {
        String policyGroupName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        CertPolicyGroup group = null;
        try {
            group = this.proxy.getPolicyGroupByName(policyGroupName);
            if (group == null) {
                System.out.println("No policy group with name " + policyGroupName + " found");
                return;
            }
            if (group.getCertPolicyGroupReltn() == null || group.getCertPolicyGroupReltn().length == 0) {
                System.out.println("Group has no policies associated with it.");
                return;
            }
            this.policyUsagePrinter.printRecords(Arrays.asList(group.getCertPolicyGroupReltn()));
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy group: " + e.getMessage());
            return;
        }
    }

    @Command(name="AddPolicyToGroup", usage="Adds an existing policy to a group with a provided usage.\r\n  policyName groupNames policyUse incoming outgoing\r\n\t policyName: Name of the policy to add to the group.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t groupName: Name of the policy group to add the policy to.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t policyUse: Usage name of the policy in the group.  Must be one of the following values: TRUST, PRIVATE_RESOLVER, PUBLIC_RESOLVER.\r\n\t incoming: Indicates if policy is used for incoming messages.  Must be one of the following values: true, false\r\n\t outgoing: Indicates if policy is used for outgoing messages.  Must be one of the following values: true, false")
    public void addPolicyToGroup(String[] args) {
        String policyName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String groupName = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        String policyUse = StringArrayUtil.getRequiredValue((String[])args, (int)2);
        boolean incoming = Boolean.parseBoolean(StringArrayUtil.getRequiredValue((String[])args, (int)3));
        boolean outgoing = Boolean.parseBoolean(StringArrayUtil.getRequiredValue((String[])args, (int)4));
        CertPolicy policy = null;
        try {
            policy = this.proxy.getPolicyByName(policyName);
            if (policy == null) {
                System.out.println("No policy with name " + policyName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy: " + e.getMessage());
            return;
        }
        CertPolicyGroup group = null;
        try {
            group = this.proxy.getPolicyGroupByName(groupName);
            if (group == null) {
                System.out.println("No policy group with name " + groupName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy group: " + e.getMessage());
            return;
        }
        CertPolicyUse use = CertPolicyUse.fromString((String)policyUse);
        if (use == null) {
            System.out.println("Unknow usage type");
            return;
        }
        try {
            this.proxy.addPolicyUseToGroup(group.getId(), policy.getId(), use, incoming, outgoing);
            System.out.println("Successfully added policy to group.");
        }
        catch (Exception e) {
            System.out.println("Failed to add policy to group: " + e.getMessage());
            return;
        }
    }

    @Command(name="DeletePolicyFromGroup", usage="Deletes an existing policy from a group.\r\n  policyName groupName\r\n\t policyName: Name of the policy to delete from the group.  Place the policy name in quotes (\"\") if there are spaces in the name.\r\n\t groupName: Name of the policy group to delete the policy from.  Place the policy group name in quotes (\"\") if there are spaces in the name.")
    public void deletePolicyFromGroup(String[] args) {
        String policyName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String groupName = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        long policyReltnId = -1L;
        CertPolicyGroup group = null;
        try {
            group = this.proxy.getPolicyGroupByName(groupName);
            if (group == null) {
                System.out.println("No policy group with name " + groupName + " found");
                return;
            }
            if (group.getCertPolicyGroupReltn() == null || group.getCertPolicyGroupReltn().length == 0) {
                System.out.println("Policy is not associated with group.");
                return;
            }
            for (CertPolicyGroupReltn reltn : group.getCertPolicyGroupReltn()) {
                if (reltn.getCertPolicy().getPolicyName().compareToIgnoreCase(policyName) != 0) continue;
                policyReltnId = reltn.getId();
                break;
            }
            if (policyReltnId == -1L) {
                System.out.println("Policy is not associated with group.");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy group: " + e.getMessage());
            return;
        }
        try {
            this.proxy.removePolicyUseFromGroup(policyReltnId);
            System.out.println("Successfully delete policy from group.");
        }
        catch (Exception e) {
            System.out.println("Failed to delete policy from group: " + e.getMessage());
            return;
        }
    }

    @Command(name="ListDomainPolicyGroups", usage="List policy groups within a domain\r\n  domainName\r\n\t domainName: Name of the domain.")
    public void listDomainPolicyGroups(String[] args) {
        Domain[] domains;
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            domains = this.proxy.getDomains(new String[]{domainName}, null);
            if (domains == null || domains.length == 0) {
                System.out.println("No domain with name " + domainName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup domain: " + e.getMessage());
            return;
        }
        try {
            CertPolicyGroupDomainReltn[] reltns = this.proxy.getPolicyGroupsByDomain(domains[0].getId());
            if (reltns == null || reltns.length == 0) {
                System.out.println("Domain does not have any policy groups associated with it.");
                return;
            }
            ArrayList<CertPolicyGroup> groups = new ArrayList<CertPolicyGroup>();
            for (CertPolicyGroupDomainReltn reltn : reltns) {
                groups.add(reltn.getCertPolicyGroup());
            }
            this.groupPrinter.printRecords(groups);
        }
        catch (Exception e) {
            System.out.println("Failed to lookup domain policy groups: " + e.getMessage());
            return;
        }
    }

    @Command(name="AddPolicyGroupToDomain", usage="Adds an existing policy group to an existing domain.\r\n  groupName domainName\r\n\t groupName: Name of the policy group to add to the domain.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t domainName: Name of the domain to add the group to.")
    public void addGroupToDomain(String[] args) {
        Domain[] domains;
        String groupName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        CertPolicyGroup group = null;
        try {
            group = this.proxy.getPolicyGroupByName(groupName);
            if (group == null) {
                System.out.println("No policy group with name " + groupName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup policy group: " + e.getMessage());
            return;
        }
        try {
            domains = this.proxy.getDomains(new String[]{domainName}, null);
            if (domains == null || domains.length == 0) {
                System.out.println("No domain with name " + domainName + " found");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup domain: " + e.getMessage());
            return;
        }
        try {
            CertPolicyGroupDomainReltn[] reltns = this.proxy.getPolicyGroupsByDomain(domains[0].getId());
            if (reltns != null && reltns.length > 0) {
                boolean reltnExists = false;
                for (CertPolicyGroupDomainReltn reltn : reltns) {
                    if (reltn.getCertPolicyGroup().getPolicyGroupName().compareToIgnoreCase(groupName) != 0) continue;
                    reltnExists = true;
                    break;
                }
                if (reltnExists) {
                    System.out.println("Group " + groupName + " already associated with domain " + domainName);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup existing group to domain associations: " + e.getMessage());
            return;
        }
        try {
            this.proxy.associatePolicyGroupToDomain(domains[0].getId(), group.getId());
            System.out.println("Successfully added policy to group.");
        }
        catch (Exception e) {
            System.out.println("Failed to add group to domain: " + e.getMessage());
            return;
        }
    }

    @Command(name="DeletePolicyGroupFromDomain", usage="Deletes an existing policy group from a domain.\r\n  groupName domainName \r\n\t groupName: Name of the policy group to delete from the domain.  Place the policy group name in quotes (\"\") if there are spaces in the name.\r\n\t domainName: Name of the domain to delete the policy group from.")
    public void deletePolicyGroupFromDomain(String[] args) {
        Domain[] domains;
        String groupName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        long policyGroupId = -1L;
        try {
            domains = this.proxy.getDomains(new String[]{domainName}, null);
            if (domains == null || domains.length == 0) {
                System.out.println("No domain with name " + domainName + " found");
                return;
            }
            CertPolicyGroupDomainReltn[] reltns = this.proxy.getPolicyGroupsByDomain(domains[0].getId());
            if (reltns == null || reltns.length == 0) {
                System.out.println("Policy group is not associated with domain.");
                return;
            }
            for (CertPolicyGroupDomainReltn reltn : reltns) {
                if (reltn.getCertPolicyGroup().getPolicyGroupName().compareToIgnoreCase(groupName) != 0) continue;
                policyGroupId = reltn.getCertPolicyGroup().getId();
                break;
            }
            if (policyGroupId == -1L) {
                System.out.println("Policy group is not associated with domain.");
                return;
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup domain: " + e.getMessage());
            return;
        }
        try {
            this.proxy.disassociatePolicyGroupFromDomain(domains[0].getId(), policyGroupId);
            System.out.println("Successfully delete policy group from domain.");
        }
        catch (Exception e) {
            System.out.println("Failed to delete policy group from domain: " + e.getMessage());
            return;
        }
    }
}

