/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.util.ArrayList;
import java.util.Collection;
import org.nhind.config.CertPolicyGroupReltn;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;

public class PolicyUsagePrinter
extends AbstractRecordPrinter<CertPolicyGroupReltn> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList<AbstractRecordPrinter.ReportColumn>();
    protected static final String POLICY_NAME_COL = "Policy Name";
    protected static final String POLICY_LEXICON_COL = "Lexicon";
    protected static final String POLICY_USAGE_COL = "Usage";
    protected static final String INCOMING_COL = "Incoming";
    protected static final String OUTGOING_COL = "Outgoing";

    public PolicyUsagePrinter() {
        super(110, REPORT_COLS);
    }

    @Override
    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, CertPolicyGroupReltn reltn) {
        try {
            if (column.header.equals(POLICY_NAME_COL)) {
                return reltn.getCertPolicy().getPolicyName();
            }
            if (column.header.equals(POLICY_LEXICON_COL)) {
                return reltn.getCertPolicy().getLexicon().toString();
            }
            if (column.header.equals(INCOMING_COL)) {
                return Boolean.toString(reltn.isIncoming());
            }
            if (column.header.equals(OUTGOING_COL)) {
                return Boolean.toString(reltn.isOutgoing());
            }
            return super.getColumnValue(column, reltn);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_NAME_COL, 40, "PolicyName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_LEXICON_COL, 20, POLICY_LEXICON_COL));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_USAGE_COL, 20, "PolicyUse"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(INCOMING_COL, 12, INCOMING_COL));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(OUTGOING_COL, 12, OUTGOING_COL));
    }
}

