/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.impl.machine;

import java.lang.reflect.Constructor;
import java.util.Stack;
import java.util.Vector;
import org.nhindirect.policy.ExecutionEngine;
import org.nhindirect.policy.Opcode;
import org.nhindirect.policy.PolicyOperator;
import org.nhindirect.policy.PolicyOperatorExecutor;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyValue;
import org.nhindirect.policy.impl.machine.StackMachineEntry;

public class StackMachine
implements ExecutionEngine {
    protected final Stack<PolicyValue<?>> machineStack = new Stack();

    @Override
    public Boolean evaluate(Vector<Opcode> opcodes) throws PolicyProcessException {
        Boolean retVal;
        for (Opcode opcode : opcodes) {
            StackMachineEntry entry = (StackMachineEntry)StackMachineEntry.class.cast(opcode);
            switch (entry.getEntryType()) {
                case VALUE: {
                    this.machineStack.push(entry.getValue());
                    break;
                }
                case OPERATOR: {
                    PolicyOperatorExecutor<?, ?> executor = null;
                    switch (entry.getOperator().getParamsType()) {
                        case BINARY: {
                            if (this.machineStack.size() < 2) {
                                throw new IllegalStateException("Stack machine must have at least two pushed operands for " + entry.getOperator().getOperatorText() + " operator");
                            }
                            executor = this.createOperatorExecutor(entry.getOperator(), this.machineStack.pop(), this.machineStack.pop());
                            break;
                        }
                        case UNARY: {
                            if (this.machineStack.size() < 1) {
                                throw new IllegalStateException("Stack machine must have at least one pushed operand for " + entry.getOperator().getOperatorText() + " operator");
                            }
                            executor = this.createOperatorExecutor(entry.getOperator(), this.machineStack.pop());
                        }
                    }
                    this.machineStack.push(executor.execute());
                    break;
                }
            }
        }
        if (this.machineStack.isEmpty() || this.machineStack.size() > 1) {
            throw new IllegalStateException("Stack machine is either empty or has remaining parameters to be processed.\r\n\tFinal stack size: " + this.machineStack.size());
        }
        PolicyValue<?> finalValue = this.machineStack.pop();
        try {
            retVal = (Boolean)Boolean.class.cast(finalValue.getPolicyValue());
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Final machine value must be a boolean litteral\r\n\tFinal value type: " + finalValue.getPolicyValue().getClass() + "\r\n\tFinal value value:" + finalValue.getPolicyValue().toString(), e);
        }
        return retVal;
    }

    protected PolicyOperatorExecutor<?, ?> createOperatorExecutor(PolicyOperator operator, PolicyValue<?> ... values) throws PolicyProcessException {
        PolicyOperatorExecutor executor = null;
        Constructor<?> constructor = null;
        switch (operator.getParamsType()) {
            case BINARY: {
                try {
                    constructor = operator.getExecutorClass().getConstructor(PolicyValue.class, PolicyValue.class, PolicyOperator.class);
                    break;
                }
                catch (Exception e) {
                    throw new PolicyProcessException("Failed to get constructor for operator executor.", e);
                }
            }
            case UNARY: {
                try {
                    constructor = operator.getExecutorClass().getConstructor(PolicyValue.class, PolicyOperator.class);
                    break;
                }
                catch (Exception e) {
                    throw new PolicyProcessException("Failed to get constructor for operator executor.", e);
                }
            }
        }
        try {
            executor = values.length == 1 ? (PolicyOperatorExecutor)PolicyOperatorExecutor.class.cast(constructor.newInstance(new Object[]{values[0], operator})) : (PolicyOperatorExecutor)PolicyOperatorExecutor.class.cast(constructor.newInstance(new Object[]{values[0], values[1], operator}));
        }
        catch (Exception e) {
            throw new PolicyProcessException("Failed to create operator executor.", e);
        }
        return executor;
    }
}

