/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.tools.policybuild;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.policy.PolicyLexicon;
import org.nhindirect.policy.PolicyLexiconParser;
import org.nhindirect.policy.PolicyLexiconParserFactory;
import org.nhindirect.policy.PolicyParseException;
import org.nhindirect.policy.tools.policyvalidate.ValidatePanel;

public class EditorPanel
extends JPanel {
    private static final long serialVersionUID = 414048933382044206L;
    protected JLabel fileNameLabel;
    protected JTextArea policyText;
    protected ScheduledExecutorService buildTaskSchedule;
    protected Boolean needsBuilding = false;
    protected File currentFile;
    protected ValidatePanel validatePanel;

    public EditorPanel() {
        this.initUI();
        this.addActions();
        this.buildTaskSchedule = Executors.newSingleThreadScheduledExecutor();
        this.buildTaskSchedule.scheduleAtFixedRate(new BuildTask(), 3L, 1L, TimeUnit.SECONDS);
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        this.policyText = new JTextArea();
        this.policyText.setLineWrap(true);
        this.policyText.setWrapStyleWord(true);
        this.policyText.setEditable(true);
        JScrollPane scrollPane = new JScrollPane(this.policyText);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(BorderFactory.createEtchedBorder(1));
        this.fileNameLabel = new JLabel("*New File*");
        JPanel reportPanel = new JPanel(new BorderLayout());
        reportPanel.add((Component)this.fileNameLabel, "North");
        reportPanel.add((Component)scrollPane, "Center");
        this.validatePanel = new ValidatePanel();
        this.validatePanel.setFeedMode(PolicyLexicon.SIMPLE_TEXT_V1, this.policyText.getDocument());
        JSplitPane splitPane = new JSplitPane(0, reportPanel, this.validatePanel);
        splitPane.setDividerLocation(400);
        this.add((Component)splitPane, "Center");
    }

    private void addActions() {
        this.policyText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorPanel.this.setBuildingNeeded(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorPanel.this.setBuildingNeeded(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorPanel.this.setBuildingNeeded(true);
            }
        });
    }

    public void loadFromFile(File file) {
        try {
            String text = FileUtils.readFileToString((File)file);
            this.policyText.setText(text);
            this.currentFile = file;
            this.fileNameLabel.setText(file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void savePolicyFile() {
        if (this.currentFile == null) {
            this.savePolicyFileAs();
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.currentFile, (String)this.policyText.getText());
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Error saving to file: " + e.getMessage(), "File Save Error", 0);
            return;
        }
    }

    public void savePolicyFileAs() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            int selection;
            File selectedFile = fc.getSelectedFile();
            if (selectedFile.exists() && (selection = JOptionPane.showConfirmDialog(this, "This file already exists.  Do you wish to overwrite it?", "Existing File", 0, 3)) == 1) {
                return;
            }
            try {
                FileUtils.writeStringToFile((File)selectedFile, (String)this.policyText.getText());
                this.loadFromFile(selectedFile);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, "Error saving to file: " + e.getMessage(), "File Save Error", 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBuildingNeeded() {
        Boolean bl = this.needsBuilding;
        synchronized (bl) {
            return this.needsBuilding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBuildingNeeded(boolean buildingNeeded) {
        Boolean bl = this.needsBuilding;
        synchronized (bl) {
            this.needsBuilding = buildingNeeded;
        }
    }

    protected class BuildTask
    implements Runnable {
        protected PolicyLexiconParser parser;

        public BuildTask() {
            try {
                this.parser = PolicyLexiconParserFactory.getInstance(PolicyLexicon.SIMPLE_TEXT_V1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            if (EditorPanel.this.isBuildingNeeded()) {
                if (!EditorPanel.this.policyText.getText().isEmpty()) {
                    InputStream stream = IOUtils.toInputStream((String)EditorPanel.this.policyText.getText());
                    try {
                        this.parser.parse(stream);
                        EditorPanel.this.policyText.setForeground(Color.BLACK);
                    }
                    catch (PolicyParseException e) {
                        EditorPanel.this.policyText.setForeground(Color.RED);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                }
                EditorPanel.this.setBuildingNeeded(false);
            }
        }
    }
}

