/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.policy.x509;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nhindirect.policy.x509.IssuerAttributeField;
import org.nhindirect.policy.x509.RDNAttributeIdentifier;
import org.nhindirect.policy.x509.SerialNumberAttributeField;
import org.nhindirect.policy.x509.SubjectAttributeField;
import org.nhindirect.policy.x509.SubjectPublicKeyAlgorithmField;
import org.nhindirect.policy.x509.SubjectPublicKeySizeField;
import org.nhindirect.policy.x509.TBSField;

public final class TBSFieldName
extends Enum<TBSFieldName> {
    public static final /* enum */ TBSFieldName VERSION;
    public static final /* enum */ TBSFieldName SERIAL_NUMBER;
    public static final /* enum */ TBSFieldName SIGNATURE;
    public static final /* enum */ TBSFieldName ISSUER;
    public static final /* enum */ TBSFieldName VALIDITY;
    public static final /* enum */ TBSFieldName SUBJECT;
    public static final /* enum */ TBSFieldName ISSUER_UNIQUE_ID;
    public static final /* enum */ TBSFieldName SUBJECT_UNIQUE_ID;
    public static final /* enum */ TBSFieldName EXTENSIONS;
    public static final /* enum */ TBSFieldName SUBJECT_PUBLIC_KEY_INFO;
    protected final String rfcName;
    protected final String display;
    protected final Collection<AttributeReferenceClass> subAttributes;
    protected final Class<? extends TBSField<?>> referenceClass;
    protected static final Map<String, TBSFieldName> tokenFieldMap;
    private static final /* synthetic */ TBSFieldName[] $VALUES;

    public static TBSFieldName[] values() {
        return (TBSFieldName[])$VALUES.clone();
    }

    public static TBSFieldName valueOf(String name) {
        return Enum.valueOf(TBSFieldName.class, name);
    }

    static List<AttributeReferenceClass> rdnsToReferenceClass(Class<? extends TBSField<?>> refClass) {
        ArrayList<AttributeReferenceClass> retVal = new ArrayList<AttributeReferenceClass>();
        for (RDNAttributeIdentifier rdn : (RDNAttributeIdentifier[])RDNAttributeIdentifier.class.getEnumConstants()) {
            retVal.add(new AttributeReferenceClass(rdn.getName(), refClass));
        }
        return retVal;
    }

    private TBSFieldName(String rfcName, String display, List<AttributeReferenceClass> subAttributes) {
        this.rfcName = rfcName;
        this.display = display;
        this.subAttributes = new ArrayList<AttributeReferenceClass>(subAttributes);
        this.referenceClass = null;
        if (this.subAttributes.size() > 0) {
            ArrayList<AttributeReferenceClass> addAttributes = new ArrayList<AttributeReferenceClass>();
            for (AttributeReferenceClass addRefClass : this.subAttributes) {
                addAttributes.add(new AttributeReferenceClass(addRefClass.getAttribute() + "+", addRefClass.getReferenceClass()));
            }
            this.subAttributes.addAll(addAttributes);
        }
    }

    private TBSFieldName(String rfcName, String display, Class<? extends TBSField<?>> referenceClass) {
        this.rfcName = rfcName;
        this.display = display;
        this.subAttributes = null;
        this.referenceClass = referenceClass;
    }

    public String getRfcName() {
        return this.rfcName;
    }

    public String getDisplay() {
        return this.display;
    }

    public Collection<String> getFieldTokens() {
        if (this.subAttributes == null || this.subAttributes.isEmpty()) {
            return Arrays.asList("X509.TBS." + this.rfcName, "X509.TBS." + this.rfcName + "+");
        }
        ArrayList<String> names = new ArrayList<String>();
        for (AttributeReferenceClass attrRef : this.subAttributes) {
            names.add("X509.TBS." + this.rfcName + "." + attrRef.getAttribute());
        }
        return names;
    }

    public Class<? extends TBSField<?>> getReferenceClass(String tokenName) {
        Class<? extends TBSField<?>> retVal = null;
        if (this.referenceClass != null) {
            return this.referenceClass;
        }
        int idx = tokenName.lastIndexOf(".");
        if (idx >= 0) {
            String name = tokenName.substring(idx + 1);
            for (AttributeReferenceClass attrRef : this.subAttributes) {
                if (!name.equals(attrRef.getAttribute())) continue;
                retVal = attrRef.getReferenceClass();
                break;
            }
        }
        return retVal;
    }

    public static TBSFieldName fromToken(String token) {
        return tokenFieldMap.get(token);
    }

    public String toString() {
        return this.rfcName;
    }

    static {
        TBSFieldName[] fields;
        VERSION = new TBSFieldName("Version", "Version", new ArrayList<AttributeReferenceClass>());
        SERIAL_NUMBER = new TBSFieldName("SerialNumber", "Serial Number", SerialNumberAttributeField.class);
        SIGNATURE = new TBSFieldName("Signature", "Signature", new ArrayList<AttributeReferenceClass>());
        ISSUER = new TBSFieldName("Issuer", "Issuer", TBSFieldName.rdnsToReferenceClass(IssuerAttributeField.class));
        VALIDITY = new TBSFieldName("Validity", "Validity", Arrays.asList(new AttributeReferenceClass("ValidFrom", null), new AttributeReferenceClass("ValidTo", null)));
        SUBJECT = new TBSFieldName("Subject", "Subject", TBSFieldName.rdnsToReferenceClass(SubjectAttributeField.class));
        ISSUER_UNIQUE_ID = new TBSFieldName("IssuerUniqueID", "Issuer Unique Identifier", new ArrayList<AttributeReferenceClass>());
        SUBJECT_UNIQUE_ID = new TBSFieldName("SubjectUniqueID", "Subject Unique Identifier", new ArrayList<AttributeReferenceClass>());
        EXTENSIONS = new TBSFieldName("Extensions", "Extensions", new ArrayList<AttributeReferenceClass>());
        SUBJECT_PUBLIC_KEY_INFO = new TBSFieldName("SubjectPublicKeyInfo", "Subject Public Key Info", Arrays.asList(new AttributeReferenceClass("Algorithm", SubjectPublicKeyAlgorithmField.class), new AttributeReferenceClass("Size", SubjectPublicKeySizeField.class)));
        $VALUES = new TBSFieldName[]{VERSION, SERIAL_NUMBER, SIGNATURE, ISSUER, VALIDITY, SUBJECT, ISSUER_UNIQUE_ID, SUBJECT_UNIQUE_ID, EXTENSIONS, SUBJECT_PUBLIC_KEY_INFO};
        tokenFieldMap = new HashMap<String, TBSFieldName>();
        for (TBSFieldName field : fields = (TBSFieldName[])TBSFieldName[].class.cast(TBSFieldName.class.getEnumConstants())) {
            for (String token : field.getFieldTokens()) {
                tokenFieldMap.put(token, field);
            }
        }
    }

    public static class AttributeReferenceClass {
        protected final String attribute;
        protected final Class<? extends TBSField<?>> referenceClass;

        public AttributeReferenceClass(String attribute, Class<? extends TBSField<?>> referenceClass) {
            this.attribute = attribute;
            this.referenceClass = referenceClass;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Class<? extends TBSField<?>> getReferenceClass() {
            return this.referenceClass;
        }
    }
}

