/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.store.dao.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AddressDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class AddressDaoImpl
implements AddressDao {
    @PersistenceContext
    @Autowired
    private EntityManager entityManager;
    private static final Log log = LogFactory.getLog(AddressDaoImpl.class);

    @Override
    @Transactional(readOnly=true)
    public int count() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Long result = (Long)this.entityManager.createQuery("select count(d) from Address a").getSingleResult();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: " + result.intValue()));
        }
        return result.intValue();
    }

    @Override
    @Transactional(readOnly=false)
    public void add(Address item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (item != null) {
            item.setCreateTime(Calendar.getInstance());
            item.setUpdateTime(item.getCreateTime());
            this.entityManager.persist((Object)item);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void update(Address item) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (item != null) {
            Address inDb = (Address)this.entityManager.find(Address.class, (Object)item.getId());
            inDb.setDisplayName(item.getDisplayName());
            inDb.setEndpoint(item.getEndpoint());
            inDb.setDomain(item.getDomain());
            inDb.setEmailAddress(item.getEmailAddress());
            inDb.setType(item.getType());
            inDb.setStatus(item.getStatus());
            inDb.setUpdateTime(Calendar.getInstance());
            this.entityManager.merge((Object)inDb);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    @Transactional(readOnly=false)
    public void save(Address item) {
        this.update(item);
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        int count = 0;
        if (name != null) {
            Query delete = this.entityManager.createQuery("DELETE FROM Address a WHERE UPPER(a.emailAddress) = ?1");
            delete.setParameter(1, (Object)name.toUpperCase(Locale.getDefault()));
            count = delete.executeUpdate();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: " + count + " records deleted"));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public List<Address> listAddresses(String name, int count) {
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Address get(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Address result = null;
        if (name != null) {
            Query select = this.entityManager.createQuery("SELECT DISTINCT a from Address a d WHERE UPPER(a.emailAddress) = ?1");
            result = (Address)select.setParameter(1, (Object)name.toUpperCase(Locale.getDefault())).getSingleResult();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Address> listAddresses(List<String> names, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = null;
        Query select = null;
        if (names != null) {
            StringBuffer nameList = new StringBuffer("(");
            for (String aName : names) {
                if (nameList.length() > 1) {
                    nameList.append(", ");
                }
                nameList.append("'").append(aName.toUpperCase(Locale.getDefault())).append("'");
            }
            nameList.append(")");
            String query = "SELECT a from Address a WHERE UPPER(a.emailAddress) IN " + nameList.toString();
            if (status != null) {
                select = this.entityManager.createQuery(query + " AND a.status = ?1");
                select.setParameter(1, (Object)status);
            } else {
                select = this.entityManager.createQuery(query);
            }
        } else if (status != null) {
            select = this.entityManager.createQuery("SELECT a from Address a WHERE a.status = ?1");
            select.setParameter(1, (Object)status);
        } else {
            select = this.entityManager.createQuery("SELECT a from Address a");
        }
        List rs = select.getResultList();
        result = rs.size() != 0 && rs.get(0) instanceof Address ? rs : new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Address> getByDomain(Domain domain, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = null;
        Query select = null;
        if (domain != null) {
            String query = "SELECT a from Address a WHERE a.domain = ?1";
            if (status != null) {
                select = this.entityManager.createQuery(query + " AND a.status = ?2");
                select.setParameter(1, (Object)domain);
                select.setParameter(2, (Object)status);
            } else {
                select = this.entityManager.createQuery(query);
                select.setParameter(1, (Object)domain);
            }
        } else if (status != null) {
            select = this.entityManager.createQuery("SELECT a from Address a WHERE a.status = ?1");
            select.setParameter(1, (Object)status);
        } else {
            select = this.entityManager.createQuery("SELECT a from Address a");
        }
        List rs = select.getResultList();
        result = rs.size() != 0 && rs.get(0) instanceof Address ? rs : new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
        return result;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

