/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.RevocationManager;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class CRLRevocationManager
implements RevocationManager {
    private static final Log LOGGER = LogFactory.getFactory().getInstance(CRLRevocationManager.class);
    private static final int CRL_FETCH_TIMEOUT = 3000;
    private static final String DEFAULT_CRL_CACHE_LOCATION = "CrlCache";
    private static CertificateFactory certificateFactory;
    protected static final CRLRevocationManager INSTANCE;
    protected static final Map<String, SoftReference<X509CRL>> cache;
    protected static File crlCacheLocation;

    public static CRLRevocationManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CRL> getCRLCollection() {
        Map<String, SoftReference<X509CRL>> map = cache;
        synchronized (map) {
            HashSet<CRL> retVal = new HashSet<CRL>();
            for (SoftReference<X509CRL> ref : cache.values()) {
                CRL crl = ref.get();
                if (crl == null) continue;
                retVal.add(crl);
            }
            return Collections.unmodifiableSet(retVal);
        }
    }

    protected X509CRL loadCRLs(X509Certificate certificate) {
        block6: {
            if (certificate == null) {
                return null;
            }
            X509CRL retVal = null;
            try {
                CRLDistPoint distPoints = CRLDistPoint.getInstance((Object)CRLRevocationManager.getExtensionValue(certificate, X509Extensions.CRLDistributionPoints.getId()));
                if (distPoints != null) {
                    for (DistributionPoint distPoint : distPoints.getDistributionPoints()) {
                        String distPointURL = distPoint.getDistributionPoint().getName().toString();
                        if (distPointURL.startsWith("General")) {
                            distPointURL = this.getNameString(distPointURL);
                        }
                        if ((retVal = this.getCrlFromUri(distPointURL)) == null) continue;
                        return retVal;
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block6;
                LOGGER.warn((Object)("Unable to handle CDP CRL(s): " + e.getMessage()));
            }
        }
        return null;
    }

    @Override
    public boolean isRevoked(X509Certificate certificate) {
        if (certificate == null) {
            return false;
        }
        X509CRL crl = this.loadCRLs(certificate);
        if (crl == null) {
            StringBuilder builder = new StringBuilder("Cannot find a CRL for certificate.").append("\r\n\tDN: ").append(certificate.getSubjectDN());
            builder.append("\r\n\tSerial Number: ").append(certificate.getSerialNumber().toString(16));
            LOGGER.warn((Object)builder.toString());
            return false;
        }
        if (crl.isRevoked(certificate)) {
            StringBuilder builder = new StringBuilder("Certificate is revoked by CRL ").append("\r\n\tDN: ").append(certificate.getSubjectDN());
            builder.append("\r\n\tSerial Number: ").append(certificate.getSerialNumber().toString(16));
            LOGGER.warn((Object)builder.toString());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected X509CRL getCrlFromUri(String crlUrlString) {
        block39: {
            if (crlUrlString == null || crlUrlString.trim().length() == 0) {
                return null;
            }
            crlImpl = null;
            var3_3 = CRLRevocationManager.cache;
            synchronized (var3_3) {
                crlRef = CRLRevocationManager.cache.get(crlUrlString);
                if (crlRef != null && ((crlImpl = crlRef.get()) != null && crlImpl.getNextUpdate().before(new Date()) || crlImpl == null)) {
                    CRLRevocationManager.cache.remove(crlUrlString);
                    if (crlImpl != null) {
                        this.removeCrlCacheFile(crlUrlString);
                        crlImpl = null;
                    }
                }
            }
            if (crlImpl == null && !(uriFileName = CRLRevocationManager.getCacheFileName(crlUrlString)).isEmpty()) {
                cacheFile = new File(uriFileName);
                fileInStream = null;
                try {
                    if (cacheFile.exists()) {
                        var6_9 = CRLRevocationManager.cache;
                        synchronized (var6_9) {
                            fileInStream = FileUtils.openInputStream((File)cacheFile);
                            crlImpl = (X509CRL)CRLRevocationManager.certificateFactory.generateCRL(fileInStream);
                            if (crlImpl == null) {
                                throw new CRLException("CRL load from cache resulted in null CLR implementation instance.");
                            }
                            IOUtils.closeQuietly((InputStream)fileInStream);
                            fileInStream = null;
                            if (crlImpl != null && crlImpl.getNextUpdate().before(new Date())) {
                                CRLRevocationManager.cache.remove(crlUrlString);
                                this.removeCrlCacheFile(crlUrlString);
                                crlImpl = null;
                            } else {
                                CRLRevocationManager.cache.put(crlUrlString, new SoftReference<X509CRL>(crlImpl));
                            }
                        }
                    }
                    ** if (fileInStream == null) goto lbl-1000
                }
                catch (CRLException e) {
                    var7_13 = CRLRevocationManager.cache;
                    synchronized (var7_13) {
                        CRLRevocationManager.LOGGER.warn((Object)("CRL cache file " + uriFileName + " appears to be corrupt.  Deleting file."), (Throwable)e);
                        IOUtils.closeQuietly((InputStream)fileInStream);
                        this.removeCrlCacheFile(crlUrlString);
                    }
                    ** if (fileInStream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        IOUtils.closeQuietly((InputStream)fileInStream);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable t) {
                    CRLRevocationManager.LOGGER.warn((Object)("Failed to load CRL from cache file " + uriFileName), t);
                    ** if (fileInStream == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        IOUtils.closeQuietly((InputStream)fileInStream);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    {
                        catch (Throwable var9_15) {
                            if (fileInStream != null) {
                                IOUtils.closeQuietly(fileInStream);
                            }
                            throw var9_15;
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    IOUtils.closeQuietly(fileInStream);
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            if (crlImpl == null) {
                try {
                    urlConnection = new URL(crlUrlString).openConnection();
                    urlConnection.setConnectTimeout(3000);
                    crlInputStream = urlConnection.getInputStream();
                    try {
                        crlImpl = (X509CRL)CRLRevocationManager.certificateFactory.generateCRL(crlInputStream);
                    }
                    catch (Throwable t) {
                        CRLRevocationManager.LOGGER.warn((Object)("Failed to load CRL from URL " + crlUrlString), t);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)crlInputStream);
                    }
                    if (crlImpl == null) break block39;
                    var5_7 = CRLRevocationManager.cache;
                    synchronized (var5_7) {
                        CRLRevocationManager.cache.put(crlUrlString, new SoftReference<X509CRL>(crlImpl));
                        this.writeCRLCacheFile(crlUrlString, crlImpl);
                    }
                }
                catch (Exception e) {
                    CRLRevocationManager.LOGGER.warn((Object)("Unable to retrieve or parse CRL from URI " + crlUrlString));
                }
            }
        }
        return crlImpl;
    }

    protected String getNameString(String generalNameString) {
        int index = (generalNameString = generalNameString.trim()).indexOf("http");
        if (index > -1) {
            generalNameString = generalNameString.substring(index);
        } else {
            index = generalNameString.indexOf("ldap");
            if (index > -1) {
                generalNameString = generalNameString.substring(index);
            } else {
                index = generalNameString.indexOf("file");
                if (index > -1) {
                    generalNameString = generalNameString.substring(index);
                }
            }
        }
        return generalNameString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeCRLCacheFile(String cacheURI, X509CRL crl) {
        String uriFileName = CRLRevocationManager.getCacheFileName(cacheURI);
        if (!uriFileName.isEmpty()) {
            File cacheFile = new File(uriFileName);
            OutputStream outStream = null;
            try {
                if (cacheFile.exists() && !cacheFile.delete()) {
                    LOGGER.warn((Object)("Could not delete old CRL cache file for URI " + cacheURI + "  File may become stale"));
                    return;
                }
                FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])crl.getEncoded());
            }
            catch (Throwable t) {
                LOGGER.warn((Object)("Failed to write CRL to cache file " + uriFileName), t);
            }
            finally {
                IOUtils.closeQuietly(outStream);
            }
        }
    }

    protected void removeCrlCacheFile(String cacheURI) {
        String uriFileName = CRLRevocationManager.getCacheFileName(cacheURI);
        if (!uriFileName.isEmpty()) {
            File cacheFile = new File(uriFileName);
            try {
                if (cacheFile.exists() && !cacheFile.delete()) {
                    LOGGER.warn((Object)("Could not delete CRL cache file " + cacheFile.getAbsolutePath()));
                }
            }
            catch (Throwable t) {
                LOGGER.warn((Object)("Could not delete CRL cache file " + cacheFile.getAbsolutePath()), t);
            }
        }
    }

    protected static String getCacheFileName(String cacheURI) {
        if (crlCacheLocation == null) {
            return "";
        }
        String retVal = "";
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] bURI = cacheURI.getBytes("UTF-8");
            md.update(bURI);
            byte[] digest = md.digest();
            String digestString = CRLRevocationManager.createDigestStringRep(digest);
            retVal = crlCacheLocation.getAbsolutePath() + File.separator + digestString + ".cache";
        }
        catch (Throwable t) {
            LOGGER.warn((Object)("Failed to create cacheURI digest for URI " + cacheURI), t);
        }
        return retVal;
    }

    protected static String createDigestStringRep(byte[] digest) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer buf = new StringBuffer(digest.length * 2);
        for (byte bt : digest) {
            buf.append(hexDigits[(bt & 0xF0) >> 4]);
            buf.append(hexDigits[bt & 0xF]);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<String, SoftReference<X509CRL>> map = cache;
        synchronized (map) {
            cache.clear();
            if (crlCacheLocation != null) {
                try {
                    FileUtils.cleanDirectory((File)crlCacheLocation);
                }
                catch (IOException e) {
                    LOGGER.warn((Object)("Failed to clean CRL cache directory " + crlCacheLocation.getAbsolutePath() + " during flush operation."), (Throwable)e);
                }
            }
        }
    }

    protected static void initCRLCacheLocation() {
        OptionsParameter param = OptionsManager.getInstance().getParameter("CRL_CACHE_LOCATION");
        String cacheLoc = param == null || param.getParamValue() == null || param.getParamValue().isEmpty() ? DEFAULT_CRL_CACHE_LOCATION : param.getParamValue();
        try {
            crlCacheLocation = new File(cacheLoc);
            if (crlCacheLocation.exists()) {
                if (!crlCacheLocation.isDirectory()) {
                    LOGGER.warn((Object)("Configured CRL cache location " + cacheLoc + " already exists and is not a directory. " + "CRL file caching will be disable"));
                    crlCacheLocation = null;
                }
            } else {
                FileUtils.forceMkdir((File)crlCacheLocation);
            }
        }
        catch (Throwable t) {
            LOGGER.warn((Object)("Failed to initialize CRL cache location " + cacheLoc + " CRL file caching will be disable"), t);
            crlCacheLocation = null;
        }
    }

    protected static DERObject getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        byte[] bytes = ext.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        return CRLRevocationManager.getObject(oid, bytes);
    }

    private static DERObject getObject(String oid, byte[] ext) throws AnnotatedException {
        DERObject dERObject;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(octs.getOctets());
            dERObject = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new NHINDException("exception processing extension " + oid, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return dERObject;
    }

    public static boolean isCRLDispPointDefined(X509Certificate cert) {
        boolean retVal = false;
        try {
            CRLDistPoint distPoints = CRLDistPoint.getInstance((Object)CRLRevocationManager.getExtensionValue(cert, X509Extensions.CRLDistributionPoints.getId()));
            if (distPoints != null && distPoints.getDistributionPoints() != null && distPoints.getDistributionPoints().length > 0) {
                retVal = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    static {
        CryptoExtensions.registerJCEProviders();
        cache = new HashMap<String, SoftReference<X509CRL>>();
        try {
            certificateFactory = CertificateFactory.getInstance("X.509", CryptoExtensions.getJCEProviderName());
        }
        catch (CertificateException e) {
            LOGGER.error((Object)"Failed to create certificate factory for CRL management ", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            LOGGER.error((Object)"Failed to create certificate factory for CRL management ", (Throwable)e);
        }
        CRLRevocationManager.initCRLCacheLocation();
        INSTANCE = new CRLRevocationManager();
    }
}

