/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import org.nhind.config.provider.DefaultRESTServiceProvider;
import org.nhind.config.rest.AddressService;
import org.nhind.config.rest.AnchorService;
import org.nhind.config.rest.CertPolicyService;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.DNSService;
import org.nhind.config.rest.DomainService;
import org.nhind.config.rest.SettingService;
import org.nhind.config.rest.TrustBundleService;
import org.nhind.config.rest.impl.DefaultAddressService;
import org.nhind.config.rest.impl.DefaultAnchorService;
import org.nhind.config.rest.impl.DefaultCertPolicyService;
import org.nhind.config.rest.impl.DefaultCertificateService;
import org.nhind.config.rest.impl.DefaultDNSService;
import org.nhind.config.rest.impl.DefaultDomainService;
import org.nhind.config.rest.impl.DefaultSettingService;
import org.nhind.config.rest.impl.DefaultTrustBundleService;
import org.nhindirect.common.rest.ServiceSecurityManager;

public class DefaultRESTServiceModule
extends AbstractModule {
    private final ServiceSecurityManager securityManager;
    private final String serviceURL;

    protected static ServiceSecurityManager getInitiziedSecurityManager(Provider<ServiceSecurityManager> securityManagerProvider) {
        ServiceSecurityManager retVal = (ServiceSecurityManager)securityManagerProvider.get();
        retVal.init();
        return retVal;
    }

    public static DefaultRESTServiceModule create(String serviceURL, Provider<ServiceSecurityManager> securityManagerProvider) {
        return new DefaultRESTServiceModule(serviceURL, DefaultRESTServiceModule.getInitiziedSecurityManager(securityManagerProvider));
    }

    public static DefaultRESTServiceModule create(String serviceURL, ServiceSecurityManager securityManager) {
        return new DefaultRESTServiceModule(serviceURL, securityManager);
    }

    private DefaultRESTServiceModule(String serviceURL, ServiceSecurityManager securityManager) {
        this.securityManager = securityManager;
        this.serviceURL = serviceURL;
    }

    protected void configure() {
        this.bind(AddressService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultAddressService.class));
        this.bind(AnchorService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultAnchorService.class));
        this.bind(CertificateService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultCertificateService.class));
        this.bind(CertPolicyService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultCertPolicyService.class));
        this.bind(DNSService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultDNSService.class));
        this.bind(DomainService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultDomainService.class));
        this.bind(SettingService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultSettingService.class));
        this.bind(TrustBundleService.class).toProvider(new DefaultRESTServiceProvider(this.serviceURL, this.securityManager, DefaultTrustBundleService.class));
    }
}

