/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.impl;

import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.nhind.config.rest.CertPolicyService;
import org.nhind.config.rest.impl.requests.AddPolicyGroupRequest;
import org.nhind.config.rest.impl.requests.AddPolicyRequest;
import org.nhind.config.rest.impl.requests.AddPolicyUseToGroupRequest;
import org.nhind.config.rest.impl.requests.AssociatePolicyGroupToDomainRequest;
import org.nhind.config.rest.impl.requests.DeletePolicyGroupRequest;
import org.nhind.config.rest.impl.requests.DeletePolicyRequest;
import org.nhind.config.rest.impl.requests.DisassociatePolicyGroupFromDomainRequest;
import org.nhind.config.rest.impl.requests.DisassociatePolicyGroupFromDomainsRequest;
import org.nhind.config.rest.impl.requests.DisassociatePolicyGroupsFromDomainRequest;
import org.nhind.config.rest.impl.requests.GetPoliciesRequest;
import org.nhind.config.rest.impl.requests.GetPolicyByNameRequest;
import org.nhind.config.rest.impl.requests.GetPolicyGroupDomainReltnsRequest;
import org.nhind.config.rest.impl.requests.GetPolicyGroupRequest;
import org.nhind.config.rest.impl.requests.GetPolicyGroupsByDomainRequest;
import org.nhind.config.rest.impl.requests.GetPolicyGroupsRequest;
import org.nhind.config.rest.impl.requests.RemovePolicyUseFromGroupRequest;
import org.nhind.config.rest.impl.requests.UpdatePolicyGroupRequest;
import org.nhind.config.rest.impl.requests.UpdatePolicyRequest;
import org.nhindirect.common.rest.AbstractSecuredService;
import org.nhindirect.common.rest.ServiceRequest;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;

public class DefaultCertPolicyService
extends AbstractSecuredService
implements CertPolicyService {
    public DefaultCertPolicyService(String serviceUrl, HttpClient httpClient, ServiceSecurityManager securityManager) {
        super(serviceUrl, httpClient, securityManager);
    }

    @Override
    public Collection<CertPolicy> getPolicies() throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetPoliciesRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager));
    }

    @Override
    public CertPolicy getPolicyByName(String policyName) throws ServiceException {
        Collection policies = (Collection)this.callWithRetry((ServiceRequest)new GetPolicyByNameRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, policyName));
        return policies.isEmpty() ? null : (CertPolicy)policies.iterator().next();
    }

    @Override
    public void addPolicy(CertPolicy policy) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AddPolicyRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, policy));
    }

    @Override
    public void deletePolicy(String policyName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DeletePolicyRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, policyName));
    }

    @Override
    public void updatePolicy(String policyName, CertPolicy policyAttributes) throws ServiceException {
        this.callWithRetry((ServiceRequest)new UpdatePolicyRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, policyName, policyAttributes));
    }

    @Override
    public Collection<CertPolicyGroup> getPolicyGroups() throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetPolicyGroupsRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager));
    }

    @Override
    public CertPolicyGroup getPolicyGroup(String groupName) throws ServiceException {
        Collection groups = (Collection)this.callWithRetry((ServiceRequest)new GetPolicyGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName));
        return groups.isEmpty() ? null : (CertPolicyGroup)groups.iterator().next();
    }

    @Override
    public void addPolicyGroup(CertPolicyGroup group) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AddPolicyGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, group));
    }

    @Override
    public void deletePolicyGroup(String groupName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DeletePolicyGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName));
    }

    @Override
    public void updatePolicyGroup(String groupName, String newGroupName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new UpdatePolicyGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName, newGroupName));
    }

    @Override
    public void addPolicyUseToGroup(String groupName, CertPolicyGroupUse use) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AddPolicyUseToGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName, use));
    }

    @Override
    public void removePolicyUseFromGroup(String groupName, CertPolicyGroupUse use) throws ServiceException {
        this.callWithRetry((ServiceRequest)new RemovePolicyUseFromGroupRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName, use));
    }

    @Override
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetPolicyGroupDomainReltnsRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager));
    }

    @Override
    public Collection<CertPolicyGroup> getPolicyGroupsByDomain(String domainName) throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetPolicyGroupsByDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, domainName));
    }

    @Override
    public void associatePolicyGroupToDomain(String groupName, String domainName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AssociatePolicyGroupToDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName, domainName));
    }

    @Override
    public void disassociatePolicyGroupFromDomain(String groupName, String domainName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociatePolicyGroupFromDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName, domainName));
    }

    @Override
    public void disassociatePolicyGroupsFromDomain(String domainName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociatePolicyGroupsFromDomainRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, domainName));
    }

    @Override
    public void disassociatePolicyGroupFromDomains(String groupName) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DisassociatePolicyGroupFromDomainsRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, groupName));
    }
}

