/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.impl;

import java.util.Collection;
import org.apache.http.client.HttpClient;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.impl.requests.AddCertificateRequest;
import org.nhind.config.rest.impl.requests.DeleteCertificateByOwnerRequest;
import org.nhind.config.rest.impl.requests.DeleteCertificatesByIdsRequest;
import org.nhind.config.rest.impl.requests.GetAllCertificatesRequest;
import org.nhind.config.rest.impl.requests.GetCertificatesByOwnerAndThumbprintRequest;
import org.nhind.config.rest.impl.requests.GetCertificatesByOwnerRequest;
import org.nhindirect.common.rest.AbstractSecuredService;
import org.nhindirect.common.rest.ServiceRequest;
import org.nhindirect.common.rest.ServiceSecurityManager;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.config.model.Certificate;

public class DefaultCertificateService
extends AbstractSecuredService
implements CertificateService {
    public DefaultCertificateService(String serviceUrl, HttpClient httpClient, ServiceSecurityManager securityManager) {
        super(serviceUrl, httpClient, securityManager);
    }

    @Override
    public Collection<Certificate> getAllCertificates() throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetAllCertificatesRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager));
    }

    @Override
    public Collection<Certificate> getCertificatesByOwner(String owner) throws ServiceException {
        return (Collection)this.callWithRetry((ServiceRequest)new GetCertificatesByOwnerRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, owner));
    }

    @Override
    public Certificate getCertificatesByOwnerAndThumbprint(String owner, String thumbprint) throws ServiceException {
        Collection certs = (Collection)this.callWithRetry((ServiceRequest)new GetCertificatesByOwnerAndThumbprintRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, owner, thumbprint));
        return certs.isEmpty() ? null : (Certificate)certs.iterator().next();
    }

    @Override
    public void addCertificate(Certificate cert) throws ServiceException {
        this.callWithRetry((ServiceRequest)new AddCertificateRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, cert));
    }

    @Override
    public void deleteCertificatesByIds(Collection<Long> ids) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DeleteCertificatesByIdsRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, ids));
    }

    @Override
    public void deleteCertificateByOwner(String owner) throws ServiceException {
        this.callWithRetry((ServiceRequest)new DeleteCertificateByOwnerRequest(this.httpClient, this.serviceURL, this.jsonMapper, this.securityManager, owner));
    }
}

