/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.net.URL;
import java.util.Arrays;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhindirect.config.manager.AnchorCommands;
import org.nhindirect.config.manager.CertCommands;
import org.nhindirect.config.manager.DNSRecordCommands;
import org.nhindirect.config.manager.DomainCommands;
import org.nhindirect.config.manager.PolicyCommands;
import org.nhindirect.config.manager.SettingsCommands;
import org.nhindirect.config.manager.TrustBundleCommands;
import org.nhindirect.dns.tools.utils.Commands;

public class ConfigManager {
    private static final String DEFAULT_CONFIG_URL = "http://localhost:8081/config-service/ConfigurationService";
    private final Commands commands;
    private static boolean exitOnEndCommands = true;

    public static void main(String[] args) {
        String[] passArgs = null;
        String configURL = null;
        if (args.length > 1 && args[0].equalsIgnoreCase("configurl")) {
            configURL = args[1];
            passArgs = args.length > 2 ? Arrays.copyOfRange(args, 2, args.length) : new String[]{};
        }
        if (configURL == null) {
            configURL = DEFAULT_CONFIG_URL;
            passArgs = args;
        }
        ConfigManager manager = null;
        try {
            manager = new ConfigManager(new URL(configURL));
        }
        catch (Exception e) {
            System.err.println("Invalid config URL");
        }
        boolean runCommand = false;
        if (manager != null) {
            runCommand = manager.run(passArgs);
        }
        if (exitOnEndCommands) {
            System.exit(runCommand ? 0 : -1);
        }
    }

    public ConfigManager(URL configURL) {
        ConfigurationServiceProxy proxy = new ConfigurationServiceProxy(configURL.toExternalForm());
        this.commands = new Commands("Configuration Management Console");
        this.commands.register((Object)new DNSRecordCommands(proxy));
        this.commands.register((Object)new CertCommands(proxy));
        this.commands.register((Object)new PolicyCommands(proxy));
        this.commands.register((Object)new SettingsCommands(proxy));
        this.commands.register((Object)new DomainCommands(proxy));
        this.commands.register((Object)new AnchorCommands(proxy));
        this.commands.register((Object)new TrustBundleCommands(proxy));
        System.out.println("Configuration service URL: " + configURL.toExternalForm());
    }

    public boolean run(String[] args) {
        if (args != null && args.length > 0) {
            return this.commands.run(args);
        }
        this.commands.runInteractive();
        System.out.println("Shutting Down Configuration Manager Console");
        return true;
    }

    public static void setExitOnEndCommands(boolean exit) {
        exitOnEndCommands = exit;
    }
}

