/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.util.Arrays;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Domain;
import org.nhind.config.EntityStatus;
import org.nhindirect.config.manager.printers.DomainPrinter;
import org.nhindirect.dns.tools.utils.Command;
import org.nhindirect.dns.tools.utils.StringArrayUtil;

public class DomainCommands {
    private static final String LIST_DOMAINS_USAGE = "Lists domains in the system";
    private static final String ADD_DOMAIN_USAGE = "Adds a domain to the system.\r\n  domainName postmasterEmail \r\n\t domainName: The name of the new domain.\r\n\t postmasterEmail: The email address of the postmaster of the domain.";
    private static final String DELETE_DOMAIN_USAGE = "Deletes a domain from the system.\r\n  id \r\n\t id: The id of the domain.";
    protected ConfigurationServiceProxy proxy;
    protected final DomainPrinter domainPrinter;

    DomainCommands(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
        this.domainPrinter = new DomainPrinter();
    }

    @Command(name="ListDomains", usage="Lists domains in the system")
    public void listDomains(String[] args) {
        try {
            Domain[] domains = this.proxy.listDomains(null, 100000);
            if (domains == null || domains.length == 0) {
                System.out.println("No domains have been created.");
                return;
            }
            this.domainPrinter.printRecords(Arrays.asList(domains));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to retrieve domains: " + e.getMessage());
        }
    }

    @Command(name="AddDomain", usage="Adds a domain to the system.\r\n  domainName postmasterEmail \r\n\t domainName: The name of the new domain.\r\n\t postmasterEmail: The email address of the postmaster of the domain.")
    public void addDomain(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String postmasterEmail = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        try {
            Domain[] exDomain = this.proxy.listDomains(domainName, 1);
            if (exDomain != null && exDomain.length > 0) {
                System.out.println("The domain " + domainName + " already exists in the system");
                return;
            }
            Domain newDomain = new Domain();
            newDomain.setDomainName(domainName);
            newDomain.setPostMasterEmail(postmasterEmail);
            newDomain.setStatus(EntityStatus.ENABLED);
            this.proxy.addDomain(newDomain);
            System.out.println("Domain " + domainName + " successfully added.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to add new domain: " + e.getMessage());
        }
    }

    @Command(name="DeleteDomain", usage="Deletes a domain from the system.\r\n  id \r\n\t id: The id of the domain.")
    public void deleteDomain(String[] args) {
        String strId = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        long id = Long.parseLong(strId);
        try {
            Domain exDomain = this.proxy.getDomain(Long.valueOf(id));
            if (exDomain == null) {
                System.out.println("The domain with the id " + id + " does not exists in the system");
                return;
            }
            this.proxy.removeDomainById(Long.valueOf(id));
            System.out.println("Domain " + exDomain.getDomainName() + " successfully removed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to add new domain: " + e.getMessage());
        }
    }
}

