/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.util.Arrays;
import org.nhind.config.ConfigurationServiceProxy;
import org.nhind.config.Setting;
import org.nhindirect.config.manager.printers.RecordPrinter;
import org.nhindirect.config.manager.printers.SettingRecordPrinter;
import org.nhindirect.dns.tools.utils.Command;

public class SettingsCommands {
    private static final String LIST_SETTINGS_USAGE = "Lists all settings in the system";
    protected ConfigurationServiceProxy proxy;
    protected RecordPrinter<Setting> settingsPrinter;

    public SettingsCommands(ConfigurationServiceProxy proxy) {
        this.proxy = proxy;
        this.settingsPrinter = new SettingRecordPrinter();
    }

    @Command(name="ListSettings", usage="Lists all settings in the system")
    public void listCerts(String[] args) {
        try {
            Setting[] settings = this.proxy.getSettingsByNames(null);
            if (settings == null || settings.length == 0) {
                System.out.println("No settings found");
            } else {
                this.settingsPrinter.printRecords(Arrays.asList(settings));
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup certificates: " + e.getMessage());
        }
    }
}

