/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.nhind.config.TrustBundleAnchor;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.manager.printers.CertUtils;
import org.nhindirect.stagent.cert.Thumbprint;

public class BundleAnchorRecordPrinter
extends AbstractRecordPrinter<TrustBundleAnchor> {
    protected static final String ANCHOR_NAME_COL = "Anchor Name";
    protected static final String TP_NAME_COL = "Thumbprint";
    protected static final String EXPIRES_COL = "Expires";
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList<AbstractRecordPrinter.ReportColumn>();
    protected final DateFormat dtFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");

    public BundleAnchorRecordPrinter() {
        super(170, REPORT_COLS);
    }

    @Override
    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, TrustBundleAnchor record) {
        try {
            X509Certificate anchor = CertUtils.toX509Certificate(record.getData());
            if (column.header.equals(ANCHOR_NAME_COL)) {
                X509Principal principal = PrincipalUtil.getSubjectX509Principal((X509Certificate)anchor);
                Vector values = principal.getValues(X509Name.CN);
                String cn = (String)values.get(0);
                return cn;
            }
            if (column.header.equals(TP_NAME_COL)) {
                return Thumbprint.toThumbprint((X509Certificate)anchor).toString();
            }
            if (column.header.equals(EXPIRES_COL)) {
                return this.dtFormat.format(record.getValidEndDate().getTime());
            }
            return super.getColumnValue(column, record);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ANCHOR_NAME_COL, 50, "AnchorAsX509Certificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(TP_NAME_COL, 44, "AnchorAsX509Certificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(EXPIRES_COL, 20, EXPIRES_COL));
    }
}

