/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.nhind.config.rest.AnchorService;
import org.nhind.config.rest.DomainService;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.StringArrayUtil;
import org.nhindirect.config.manager.printers.AnchorRecordPrinter;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.utils.CertUtils;

public class AnchorCommands {
    private static final String LIST_ANCHORS_USAGE = "Lists all anchors in the system";
    private static final String IMPORT_ANCHOR_USAGE = "Imports a trust anchor certificate file into the system and associates it to a domain.\r\n  anchor domainName incoming outgoing\r\n\t anchor: Fully qualified path and file name of the X509 certificate anchor file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t domainName: Name of the domain that the anchor will be associated with\r\n\t incoming: Indicates if the anchor should be used to trust incoming messages.  Valid values are true or false\r\n\t outgoing: Indicates if the anchor should be used to trust outgoing messages.  Valid values are true or false";
    private static final String DELETE_ANCHOR_USAGE = "Deletes an anchor from the system by id.\r\n  id\r\n\t id: Id of the anchor to be deleted";
    private static final String EXPORT_ANCHOR_USAGE = "Exports an anchor to a DER encoded file.\r\n  owner thumbprint \r\n\t owner: domain owner of the anchor\r\n\t thumbprint: thumbprint of the anchor";
    protected AnchorService anchorService;
    protected DomainService domainService;
    protected final AnchorRecordPrinter anchorPrinter;

    public AnchorCommands(AnchorService anchorService, DomainService domainService) {
        this.anchorService = anchorService;
        this.domainService = domainService;
        this.anchorPrinter = new AnchorRecordPrinter();
    }

    @Command(name="ListAnchors", usage="Lists all anchors in the system")
    public void listAncors(String[] args) {
        try {
            Collection anchors = this.anchorService.getAnchors();
            if (anchors == null || anchors.size() == 0) {
                System.out.println("No anchors found");
            } else {
                this.anchorPrinter.printRecords(anchors);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to get anchors: " + e.getMessage());
        }
    }

    @Command(name="ImportAnchor", usage="Imports a trust anchor certificate file into the system and associates it to a domain.\r\n  anchor domainName incoming outgoing\r\n\t anchor: Fully qualified path and file name of the X509 certificate anchor file.  Place the file name in quotes (\"\") if there are spaces in the path or name.\r\n\t domainName: Name of the domain that the anchor will be associated with\r\n\t incoming: Indicates if the anchor should be used to trust incoming messages.  Valid values are true or false\r\n\t outgoing: Indicates if the anchor should be used to trust outgoing messages.  Valid values are true or false")
    public void importAnchor(String[] args) {
        String fileLoc = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        boolean incoming = Boolean.parseBoolean(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        boolean outgoing = Boolean.parseBoolean(StringArrayUtil.getRequiredValue((String[])args, (int)3));
        try {
            Domain exDomain = this.domainService.getDomain(domainName);
            if (exDomain == null) {
                System.out.println("The domain " + domainName + " does not exists in the system");
                return;
            }
            byte[] certBytes = FileUtils.readFileToByteArray((File)new File(fileLoc));
            if (certBytes != null) {
                Anchor anchor = new Anchor();
                anchor.setCertificateData(certBytes);
                anchor.setIncoming(incoming);
                anchor.setOutgoing(outgoing);
                anchor.setOwner(exDomain.getDomainName());
                anchor.setStatus(EntityStatus.ENABLED);
                this.anchorService.addAnchor(anchor);
                System.out.println("Successfully imported trust anchor.");
            }
        }
        catch (IOException e) {
            System.out.println("Error reading file " + fileLoc + " : " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error importing trust anchor " + fileLoc + " : " + e.getMessage());
        }
    }

    @Command(name="ExportAnchor", usage="Exports an anchor to a DER encoded file.\r\n  owner thumbprint \r\n\t owner: domain owner of the anchor\r\n\t thumbprint: thumbprint of the anchor")
    public void exportAnchor(String[] args) {
        String owner = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String thumbprint = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        try {
            Collection anchors = this.anchorService.getAnchorsForOwner(owner, true, true, thumbprint);
            if (anchors == null || anchors.size() == 0) {
                System.out.println("Anchor does not exists.");
                return;
            }
            for (Anchor anchor : anchors) {
                X509Certificate cert = CertUtils.toX509Certificate((byte[])anchor.getCertificateData());
                String certFileHold = CryptoExtensions.getSubjectAddress((X509Certificate)cert) + ".der";
                File certFile = new File(certFileHold);
                if (certFile.exists()) {
                    certFile.delete();
                }
                System.out.println("Writing anchor file: " + certFile.getAbsolutePath());
                try {
                    FileUtils.writeByteArrayToFile((File)certFile, (byte[])cert.getEncoded());
                }
                catch (Exception e) {
                    System.err.println("Failed to write anchor to file: " + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error exporting anchor: " + e.getMessage());
        }
    }

    @Command(name="DeleteAnchor", usage="Deletes an anchor from the system by id.\r\n  id\r\n\t id: Id of the anchor to be deleted")
    public void deleteUnmagedCert(String[] args) {
        String id = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            this.anchorService.deleteAnchorsByIds(Arrays.asList(Long.parseLong(id)));
            System.out.println("Anchor with id " + id + " removed");
        }
        catch (Exception e) {
            System.out.println("Error deleting anchor: " + e.getMessage());
        }
    }
}

