/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.util.Arrays;
import org.nhind.config.rest.AddressService;
import org.nhind.config.rest.AnchorService;
import org.nhind.config.rest.CertPolicyService;
import org.nhind.config.rest.CertificateService;
import org.nhind.config.rest.DNSService;
import org.nhind.config.rest.DomainService;
import org.nhind.config.rest.SettingService;
import org.nhind.config.rest.TrustBundleService;
import org.nhindirect.common.tooling.Commands;
import org.nhindirect.config.manager.AddressCommands;
import org.nhindirect.config.manager.AnchorCommands;
import org.nhindirect.config.manager.CertCommands;
import org.nhindirect.config.manager.DNSRecordCommands;
import org.nhindirect.config.manager.DomainCommands;
import org.nhindirect.config.manager.PolicyCommands;
import org.nhindirect.config.manager.SettingsCommands;
import org.nhindirect.config.manager.TrustBundleCommands;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication
public class ConfigManager
implements CommandLineRunner {
    @Autowired
    protected DomainService domainService;
    @Autowired
    protected SettingService settingService;
    @Autowired
    protected DNSService dnsService;
    @Autowired
    protected CertificateService certService;
    @Autowired
    protected AnchorService anchorService;
    @Autowired
    protected CertPolicyService certPolicyService;
    @Autowired
    protected TrustBundleService bundleService;
    @Autowired
    protected AddressService addressService;
    private Commands commands;
    private static boolean exitOnEndCommands = true;

    public static void main(String[] args) {
        SpringApplication.run(ConfigManager.class, (String[])args);
    }

    public void run(String ... args) {
        String[] passArgs = null;
        for (int i = 0; i < args.length; ++i) {
            passArgs = args.length - i > 2 ? Arrays.copyOfRange(args, i, args.length) : new String[]{};
        }
        boolean runCommand = false;
        runCommand = this.runApp(passArgs);
        if (exitOnEndCommands) {
            System.exit(runCommand ? 0 : -1);
        }
    }

    public boolean runApp(String[] args) {
        this.commands = new Commands("Configuration Management Console");
        this.commands.register((Object)new SettingsCommands(this.settingService));
        this.commands.register((Object)new DNSRecordCommands(this.dnsService));
        this.commands.register((Object)new CertCommands(this.certService));
        this.commands.register((Object)new DomainCommands(this.domainService));
        this.commands.register((Object)new AnchorCommands(this.anchorService, this.domainService));
        this.commands.register((Object)new PolicyCommands(this.certPolicyService, this.domainService));
        this.commands.register((Object)new TrustBundleCommands(this.bundleService, this.domainService));
        this.commands.register((Object)new AddressCommands(this.addressService));
        if (args != null && args.length > 0) {
            return this.commands.run(args);
        }
        this.commands.runInteractive();
        System.out.println("Shutting Down Configuration Manager Console");
        return true;
    }

    public static void setExitOnEndCommands(boolean exit) {
        exitOnEndCommands = exit;
    }
}

