/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.util.Arrays;
import org.nhind.config.rest.DNSService;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.StringArrayUtil;
import org.nhindirect.config.manager.DNSRecordParser;
import org.nhindirect.config.manager.printers.DNSRecordPrinter;
import org.nhindirect.config.manager.printers.DefaultDNSRecordPrinter;
import org.nhindirect.config.model.DNSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;

public class DNSRecordCommands {
    private static final String IMPORT_MX_USAGE = "Import a new MX dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the MX record binary file. Can have any (or no extension)";
    private static final String IMPORT_SOA_USAGE = "Import a new SOA dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the SOA record binary file. Can have any (or no extension)";
    private static final String IMPORT_ADDRESS_USAGE = "Import a new A dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the A record binary file. Can have any (or no extension)";
    private static final String ADD_MX_USAGE = "Add a new MX dns record.\r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record";
    private static final String ENSURE_MX_USAGE = "Adds a new MX dns record if an identical one does't already exist. \r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record";
    private static final String ADD_NS_USAGE = "Add a new NS dns record.\r\n  domainname target ttl\r\n\t domainname: email domain name for the record\r\n\t target: the dns server name that will handle requests for the domain\r\n\t ttl: time to live in seconds";
    private static final String ENSURE_NS_USAGE = "Adds a new NS dns record if an identical one does't already exist. \r\n  domainname target ttl\r\n\t domainname: email domain name for the record\r\n\t target: the dns server name that will handle requests for the domain\r\n\t ttl: time to live in seconds";
    private static final String ADD_TXT_USAGE = "Add a new TXT dns record.\r\n  name text ttl\r\n\t name: the name of the text entry\r\n\t alias: the text value of the record\r\n\t ttl: time to live in seconds";
    private static final String ENSURE_TXT_USAGE = "Adds a new TXT dns record if an identical one does't already exist. \r\n  name text ttl\r\n\t name: the name of the text entry\r\n\t alias: the text value of the record\r\n\t ttl: time to live in seconds";
    private static final String ADD_CNAME_USAGE = "Add a new CNAME dns record.\r\n  name alias ttl\r\n\t name: the name that will be aliased\r\n\t alias: the value of the alias\r\n\t ttl: time to live in seconds";
    private static final String ENSURE_CNAME_USAGE = "Adds a new CNAME dns record if an identical one does't already exist. \r\n  name alias ttl\r\n\t name: the name that will be aliased\r\n\t alias: the value of the alias\r\n\t ttl: time to live in seconds";
    private static final String ADD_SOA_USAGE = "Add a new SOA dns record.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.";
    private static final String ENSURE_SOA_USAGE = "Add a new SOA dns record if an identical one does not exist.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.";
    private static final String ADD_ANAME_USAGE = "Add a new ANAME dns record.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int";
    private static final String ENSURE_ANAME_USAGE = "Add a new ANAME dns record if an identical one does not exist.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int";
    private static final String REMOVE_MX_USAGE = "Remove an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database";
    private static final String REMOVE_SOA_USAGE = "Remove an existing SOA record by ID.\r\n\trecordid\r\nt\t recordid: record id to be removed from the database";
    private static final String REMOVE_ANAME_USAGE = "Remove an existing ANAME record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database";
    private static final String GET_ALL_USAGE = "Gets all records in the DNS store.";
    private static final String GET_SOA_CONTACTS = "Gets a list of all the different SOA contacts.";
    private static final String ADD_SRV_USAGE = "Add a new SRV dns record.\r\n  name target port priority weight ttl\r\n\t name: the name of the SRV entry\r\n\t target: the server that hosts the service of the SRV entry\r\n\t port: the IP port to use when conneting to the target\r\n\t priority: the priority the record compared to other SRV records of the same name\r\n\t weight: the weight the record compared to other SRV records of the same name and priority\r\n\t ttl: time to live in seconds";
    private static final String ENSURE_SRV_USAGE = "Adds a new SRV dns record if an identical one does't already exist. \r\n  name target port priority weight ttl\r\n\t name: the name of the SRV entry\r\n\t target: the server that hosts the service of the SRV entry\r\n\t port: the IP port to use when conneting to the target\r\n\t priority: the priority the record compared to other SRV records of the same name\r\n\t weight: the weight the record compared to other SRV records of the same name and priority\r\n\t ttl: time to live in seconds";
    private DNSRecordPrinter printer;
    private DNSRecordParser parser = new DNSRecordParser();
    private DNSService proxy;

    public DNSRecordCommands(DNSService proxy) {
        this.printer = new DefaultDNSRecordPrinter();
        this.proxy = proxy;
    }

    private DNSRecord fromRecord(Record rec) {
        DNSRecord retVal = new DNSRecord();
        retVal.setData(rec.rdataToWireCanonical());
        retVal.setDclass(rec.getDClass());
        retVal.setName(rec.getName().toString());
        retVal.setTtl(rec.getTTL());
        retVal.setType(rec.getType());
        return retVal;
    }

    private DNSRecord loadAndVerifyDnsRecordFromBin(String path) {
        File recFile = new File(path);
        if (!recFile.exists()) {
            throw new IllegalArgumentException("Record file " + recFile.getAbsolutePath() + " not found");
        }
        Record rec = null;
        try {
            byte[] wire = FileUtils.readFileToByteArray((File)recFile);
            rec = Record.fromWire((byte[])wire, (int)1);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading file " + recFile.getAbsolutePath() + " : " + e.getMessage(), e);
        }
        return rec != null ? this.fromRecord(rec) : null;
    }

    private void addDNS(DNSRecord dnsRecord) {
        try {
            this.proxy.addDNSRecord(dnsRecord);
            System.out.println("Record added successfully.");
        }
        catch (ServiceException e) {
            throw new RuntimeException("Error adding DNS record: " + e.getMessage(), e);
        }
    }

    private void removeDNS(long recordId) {
        try {
            this.proxy.deleteDNSRecordsByIds(java.util.Arrays.asList(recordId));
            System.out.println("Record removed successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
    }

    private void importRecord(String path, int type) {
        DNSRecord dnsRecord = this.loadAndVerifyDnsRecordFromBin(path);
        if (dnsRecord.getType() != type) {
            throw new IllegalArgumentException("File " + path + " does not contain the requested record type");
        }
        this.addDNS(dnsRecord);
    }

    @Command(name="Dns_MX_Import", usage="Import a new MX dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the MX record binary file. Can have any (or no extension)")
    public void mXImport(String[] args) {
        String path = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        this.importRecord(path, 15);
    }

    @Command(name="Dns_SOA_Import", usage="Import a new SOA dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the SOA record binary file. Can have any (or no extension)")
    public void sOAImport(String[] args) {
        String path = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        this.importRecord(path, 6);
    }

    @Command(name="Dns_ANAME_Import", usage="Import a new A dns record from a binary file.\r\n\tfilepath \r\n\t filePath: path to the A record binary file. Can have any (or no extension)")
    public void importAddress(String[] args) {
        String path = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        this.importRecord(path, 1);
    }

    @Command(name="Dns_MX_Add", usage="Add a new MX dns record.\r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record")
    public void addMX(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseMX(args));
        this.addDNS(record);
    }

    @Command(name="Dns_MX_Ensure", usage="Adds a new MX dns record if an identical one does't already exist. \r\n  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record")
    public void ensureMX(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseMX(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_TXT_Add", usage="Add a new TXT dns record.\r\n  name text ttl\r\n\t name: the name of the text entry\r\n\t alias: the text value of the record\r\n\t ttl: time to live in seconds")
    public void addTXT(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseTXT(args));
        this.addDNS(record);
    }

    @Command(name="Dns_TXT_Ensure", usage="Adds a new TXT dns record if an identical one does't already exist. \r\n  name text ttl\r\n\t name: the name of the text entry\r\n\t alias: the text value of the record\r\n\t ttl: time to live in seconds")
    public void ensureTXT(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseTXT(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_CNAME_Add", usage="Add a new CNAME dns record.\r\n  name alias ttl\r\n\t name: the name that will be aliased\r\n\t alias: the value of the alias\r\n\t ttl: time to live in seconds")
    public void addCNAME(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseCNAME(args));
        this.addDNS(record);
    }

    @Command(name="Dns_CNAME_Ensure", usage="Adds a new CNAME dns record if an identical one does't already exist. \r\n  name alias ttl\r\n\t name: the name that will be aliased\r\n\t alias: the value of the alias\r\n\t ttl: time to live in seconds")
    public void ensureCNAME(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseCNAME(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_NS_Add", usage="Add a new NS dns record.\r\n  domainname target ttl\r\n\t domainname: email domain name for the record\r\n\t target: the dns server name that will handle requests for the domain\r\n\t ttl: time to live in seconds")
    public void addNS(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseNS(args));
        this.addDNS(record);
    }

    @Command(name="Dns_NS_Ensure", usage="Adds a new NS dns record if an identical one does't already exist. \r\n  domainname target ttl\r\n\t domainname: email domain name for the record\r\n\t target: the dns server name that will handle requests for the domain\r\n\t ttl: time to live in seconds")
    public void ensureNS(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseNS(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_SOA_Add", usage="Add a new SOA dns record.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.")
    public void addSOA(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseSOA(args));
        this.addDNS(record);
    }

    @Command(name="Dns_SOA_Ensure", usage="Add a new SOA dns record if an identical one does not exist.\r\n  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.")
    public void ensureSOA(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseSOA(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_ANAME_Add", usage="Add a new ANAME dns record.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int")
    public void addANAME(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseANAME(args));
        this.addDNS(record);
    }

    @Command(name="Dns_ANAME_Ensure", usage="Add a new ANAME dns record if an identical one does not exist.\r\n  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int")
    public void ensureANAME(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseANAME(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    @Command(name="Dns_MX_Remove", usage="Remove an existing MX record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database")
    public void removeMX(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue((String[])args, (int)0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_SOA_Remove", usage="Remove an existing SOA record by ID.\r\n\trecordid\r\nt\t recordid: record id to be removed from the database")
    public void removeSOA(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue((String[])args, (int)0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_ANAME_Remove", usage="Remove an existing ANAME record by ID.\r\n\trecordid\r\n\t recordid: record id to be removed from the database")
    public void removeANAME(String[] args) {
        long recordID = Long.parseLong(StringArrayUtil.getRequiredValue((String[])args, (int)0));
        this.removeDNS(recordID);
    }

    @Command(name="Dns_Get_All", usage="Gets all records in the DNS store.")
    public void getAll(String[] args) {
        Collection records = null;
        try {
            records = this.proxy.getDNSRecord(255, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.isEmpty()) {
            System.out.println("No records found");
        } else {
            this.print(records);
        }
    }

    @Command(name="Dns_Get_SOA_Contacts", usage="Gets a list of all the different SOA contacts.")
    public void getSoaContacts(String[] args) {
        Collection records = null;
        try {
            records = this.proxy.getDNSRecord(6, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.isEmpty()) {
            System.out.println("No records found");
        } else {
            HashMap<String, String> contacts = new HashMap<String, String>();
            for (DNSRecord dNSRecord : records) {
                SOARecord soaRec = (SOARecord)Record.newRecord((Name)this.nameFromString(dNSRecord.getName()), (int)dNSRecord.getType(), (int)dNSRecord.getDclass(), (long)dNSRecord.getTtl(), (byte[])dNSRecord.getData());
                if (contacts.get(soaRec.getAdmin().toString()) != null) continue;
                contacts.put(soaRec.getAdmin().toString(), soaRec.getAdmin().toString());
            }
            for (Map.Entry entry : contacts.entrySet()) {
                System.out.println("Contact: " + (String)entry.getKey());
            }
        }
    }

    private Name nameFromString(String str) {
        if (!str.endsWith(".")) {
            str = str + ".";
        }
        try {
            return Name.fromString((String)str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid DNS name");
        }
    }

    @Command(name="Dns_Match", usage="Resolve all records for the given domain")
    public void match(String[] args) {
        String domain = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        Collection records = null;
        Pattern pattern = Pattern.compile(domain);
        ArrayList<DNSRecord> matchedRecords = new ArrayList<DNSRecord>();
        try {
            records = this.proxy.getDNSRecord(255, "");
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.isEmpty()) {
            System.out.println("No records found");
            return;
        }
        for (DNSRecord record : records) {
            Matcher matcher = pattern.matcher(record.getName());
            if (!matcher.find()) continue;
            matchedRecords.add(record);
        }
        if (matchedRecords.size() == 0) {
            System.out.println("No records found");
            return;
        }
        this.print(matchedRecords);
    }

    @Command(name="Dns_SOA_Match", usage="Resolve SOA records for the given domain")
    public void matchSOA(String[] args) {
        this.match(StringArrayUtil.getRequiredValue((String[])args, (int)0), 6);
    }

    @Command(name="Dns_ANAME_Match", usage="Resolve Address records for the given domain")
    public void matchAName(String[] args) {
        this.match(StringArrayUtil.getRequiredValue((String[])args, (int)0), 1);
    }

    @Command(name="Dns_MX_Match", usage="Resolve MX records for the given domain")
    public void matchMX(String[] args) {
        this.match(StringArrayUtil.getRequiredValue((String[])args, (int)0), 15);
    }

    private void match(String domain, int type) {
        Collection records = this.getRecords(domain, type);
        if (records != null && !records.isEmpty()) {
            this.print(records);
        }
    }

    private Collection<DNSRecord> getRecords(String domain, int type) {
        if (!domain.endsWith(".")) {
            domain = domain + ".";
        }
        Collection records = null;
        try {
            records = this.proxy.getDNSRecord(type, domain);
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (records == null || records.isEmpty()) {
            System.out.println("No records found");
        }
        return records;
    }

    private boolean verifyIsUnique(DNSRecord record, boolean details) {
        DNSRecord existing = this.find(record);
        if (existing != null) {
            System.out.println("Record already exists");
            this.print(existing);
            return false;
        }
        return true;
    }

    private DNSRecord find(DNSRecord record) {
        Collection existingRecords = null;
        try {
            existingRecords = this.proxy.getDNSRecord(record.getType(), record.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing configuration service: " + e.getMessage(), e);
        }
        if (existingRecords == null || existingRecords.isEmpty()) {
            return null;
        }
        for (DNSRecord existingRecord : existingRecords) {
            if (!Arrays.areEqual((byte[])record.getData(), (byte[])existingRecord.getData())) continue;
            return existingRecord;
        }
        return null;
    }

    @Command(name="Dns_SRV_Add", usage="Add a new SRV dns record.\r\n  name target port priority weight ttl\r\n\t name: the name of the SRV entry\r\n\t target: the server that hosts the service of the SRV entry\r\n\t port: the IP port to use when conneting to the target\r\n\t priority: the priority the record compared to other SRV records of the same name\r\n\t weight: the weight the record compared to other SRV records of the same name and priority\r\n\t ttl: time to live in seconds")
    public void addSRV(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseSRV(args));
        this.addDNS(record);
    }

    @Command(name="Dns_SRV_Ensure", usage="Adds a new SRV dns record if an identical one does't already exist. \r\n  name target port priority weight ttl\r\n\t name: the name of the SRV entry\r\n\t target: the server that hosts the service of the SRV entry\r\n\t port: the IP port to use when conneting to the target\r\n\t priority: the priority the record compared to other SRV records of the same name\r\n\t weight: the weight the record compared to other SRV records of the same name and priority\r\n\t ttl: time to live in seconds")
    public void ensureSRV(String[] args) {
        DNSRecord record = this.fromRecord((Record)this.parser.parseSRV(args));
        if (!this.verifyIsUnique(record, false)) {
            return;
        }
        this.addDNS(record);
    }

    private void print(Collection<DNSRecord> records) {
        if (records != null) {
            for (DNSRecord record : records) {
                this.print(record);
                System.out.println("\r\n-------------------------------------------");
            }
        }
    }

    private void print(DNSRecord dnsRecord) {
        System.out.println("RecordID: " + dnsRecord.getId());
        this.printer.print(dnsRecord);
    }

    public void setRecordPrinter(DNSRecordPrinter printer) {
        this.printer = printer;
    }

    public void setConfigurationProxy(DNSService proxy) {
        this.proxy = proxy;
    }
}

