/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.net.InetAddress;
import org.nhindirect.common.tooling.StringArrayUtil;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TXTRecord;

public class DNSRecordParser {
    public static final String PARSE_ANAME_USAGE = "  hostname ipaddress ttl [notes]\r\n\t hostname: host name for the record\r\n\t ipaddress: IP address in dot notation\r\n\t ttl: time to live in seconds, 32bit int";
    public static final String PARSE_SOA_USAGE = "  domainname primarysourcedomain responsibleemail serialnumber ttl [refresh] [retry] [expire] [minimum] [notes]\r\n\t domainname: The domain name of the name server that was the primary source for this zone\r\n\t responsibleemail: Email mailbox of the hostmaster\r\n\t serialnumber: Version number of the original copy of the zone.\r\n\t ttl: time to live in seconds, 32bit int\r\n\t [refresh]: Number of seconds before the zone should be refreshed.\r\n\t [retry]: Number of seconds before failed refresh should be retried.\r\n\t [expire]: Number of seconds before records should be expired if not refreshed\r\n\t [minimum]: Minimum TTL for this zone.";
    public static final String PARSE_MX_USAGE = "  domainname exchange ttl [preference] [notes]\r\n\t domainname: email domain name for the record\r\n\t exchange: smtp server host name for the domain\r\n\t ttl: time to live in seconds\r\n\t [preference]: short value indicating preference of the record";
    public static final String PARSE_NS_USAGE = "  domainname target ttl\r\n\t domainname: email domain name for the record\r\n\t target: the dns server name that will handle requests for the domain\r\n\t ttl: time to live in seconds";
    public static final String PARSE_CNAME_USAGE = "  name alias ttl\r\n\t name: the name that will be aliased\r\n\t alias: the value of the alias\r\n\t ttl: time to live in seconds";
    public static final String PARSE_TXT_USAGE = "  name text ttl\r\n\t name: the name of the text entry\r\n\t alias: the text value of the record\r\n\t ttl: time to live in seconds";
    public static final String PARSE_SRV_USAGE = "  name target port priority weight ttl\r\n\t name: the name of the SRV entry\r\n\t target: the server that hosts the service of the SRV entry\r\n\t port: the IP port to use when conneting to the target\r\n\t priority: the priority the record compared to other SRV records of the same name\r\n\t weight: the weight the record compared to other SRV records of the same name and priority\r\n\t ttl: time to live in seconds";

    private Name nameFromString(String str) {
        if (!str.endsWith(".")) {
            str = str + ".";
        }
        try {
            return Name.fromString((String)str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid DNS name");
        }
    }

    private InetAddress inetFromString(String str) {
        try {
            return InetAddress.getByName(str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ip address");
        }
    }

    public TXTRecord parseTXT(String[] args) {
        String name = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String text = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        return new TXTRecord(this.nameFromString(name), 1, (long)ttl, text);
    }

    public CNAMERecord parseCNAME(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String alias = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        return new CNAMERecord(this.nameFromString(domainName), 1, (long)ttl, this.nameFromString(alias));
    }

    public ARecord parseANAME(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String ipAddress = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        return new ARecord(this.nameFromString(domainName), 1, (long)ttl, this.inetFromString(ipAddress));
    }

    public SOARecord parseSOA(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String primarySourceDomain = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        String responsibleEmail = StringArrayUtil.getRequiredValue((String[])args, (int)2);
        int serialNumber = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)3));
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)4));
        int refresh = Integer.parseInt(StringArrayUtil.getOptionalValue((String[])args, (int)5, (String)"0"));
        int retry = Integer.parseInt(StringArrayUtil.getOptionalValue((String[])args, (int)6, (String)"0"));
        int expire = Integer.parseInt(StringArrayUtil.getOptionalValue((String[])args, (int)7, (String)"0"));
        int minimum = Integer.parseInt(StringArrayUtil.getOptionalValue((String[])args, (int)8, (String)"0"));
        return new SOARecord(this.nameFromString(domainName), 1, (long)ttl, this.nameFromString(primarySourceDomain), this.nameFromString(responsibleEmail), (long)serialNumber, (long)refresh, (long)retry, (long)expire, (long)minimum);
    }

    public MXRecord parseMX(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String exchange = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        short pref = Short.parseShort(StringArrayUtil.getOptionalValue((String[])args, (int)3, (String)"0"));
        return new MXRecord(this.nameFromString(domainName), 1, (long)ttl, (int)pref, this.nameFromString(exchange));
    }

    public NSRecord parseNS(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String target = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        return new NSRecord(this.nameFromString(domainName), 1, (long)ttl, this.nameFromString(target));
    }

    public SRVRecord parseSRV(String[] args) {
        String name = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String target = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        int port = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)2));
        int priority = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)3));
        int weight = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)4));
        int ttl = Integer.parseInt(StringArrayUtil.getRequiredValue((String[])args, (int)5));
        return new SRVRecord(this.nameFromString(name), 1, (long)ttl, priority, weight, port, this.nameFromString(target));
    }
}

