/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.util.Collection;
import org.nhind.config.rest.DomainService;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.StringArrayUtil;
import org.nhindirect.config.manager.printers.DomainPrinter;
import org.nhindirect.config.model.Address;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.model.EntityStatus;

public class DomainCommands {
    private static final String LIST_DOMAINS_USAGE = "Lists domains in the system";
    private static final String ADD_DOMAIN_USAGE = "Adds a domain to the system.\r\n  domainName postmasterEmail \r\n\t domainName: The name of the new domain.\r\n\t postmasterEmail: The email address of the postmaster of the domain.";
    private static final String DELETE_DOMAIN_USAGE = "Deletes a domain from the system.\r\n  name \r\n\t name: The name of the domain.";
    protected DomainService domainService;
    protected final DomainPrinter domainPrinter;

    DomainCommands(DomainService domainService) {
        this.domainService = domainService;
        this.domainPrinter = new DomainPrinter();
    }

    @Command(name="ListDomains", usage="Lists domains in the system")
    public void listDomains(String[] args) {
        try {
            Collection domains = this.domainService.searchDomains("", null);
            if (domains == null || domains.size() == 0) {
                System.out.println("No domains have been created.");
                return;
            }
            this.domainPrinter.printRecords(domains);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to retrieve domains: " + e.getMessage());
        }
    }

    @Command(name="AddDomain", usage="Adds a domain to the system.\r\n  domainName postmasterEmail \r\n\t domainName: The name of the new domain.\r\n\t postmasterEmail: The email address of the postmaster of the domain.")
    public void addDomain(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String postmasterEmail = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        try {
            Domain exDomain = this.domainService.getDomain(domainName);
            if (exDomain != null) {
                System.out.println("The domain " + domainName + " already exists in the system");
                return;
            }
            Address postmasterAddress = new Address();
            postmasterAddress.setDomainName(domainName);
            postmasterAddress.setEmailAddress(postmasterEmail);
            Domain newDomain = new Domain();
            newDomain.setDomainName(domainName);
            newDomain.setPostmasterAddress(postmasterAddress);
            newDomain.setStatus(EntityStatus.ENABLED);
            this.domainService.addDomain(newDomain);
            System.out.println("Domain " + domainName + " successfully added.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to add new domain: " + e.getMessage());
        }
    }

    @Command(name="DeleteDomain", usage="Deletes a domain from the system.\r\n  name \r\n\t name: The name of the domain.")
    public void deleteDomain(String[] args) {
        String domainName = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            Domain exDomain = this.domainService.getDomain(domainName);
            if (exDomain == null) {
                System.out.println("The domain " + domainName + " does not exists in the system");
                return;
            }
            this.domainService.deleteDomain(domainName);
            System.out.println("Domain " + domainName + " successfully removed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to delete domain: " + e.getMessage());
        }
    }
}

