/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager;

import java.util.Collection;
import org.nhind.config.rest.SettingService;
import org.nhindirect.common.tooling.Command;
import org.nhindirect.common.tooling.StringArrayUtil;
import org.nhindirect.config.manager.printers.RecordPrinter;
import org.nhindirect.config.manager.printers.SettingRecordPrinter;
import org.nhindirect.config.model.Setting;

public class SettingsCommands {
    private static final String LIST_SETTINGS_USAGE = "Lists all settings in the system";
    private static final String ADD_SETTING_USAGE = "Adds a name/value setting to the system.\r\n  name value \r\n\t name: The name of the new setting.\r\n\t value: The name of the new setting.  If the value has spaces, include the setting in quotes";
    private static final String DELETE_SETTING_USAGE = "Deletes a setting from the system\r\n  name \r\n\t name: The name of the setting to delete.";
    protected SettingService proxy;
    protected RecordPrinter<Setting> settingsPrinter;

    public SettingsCommands(SettingService proxy) {
        this.proxy = proxy;
        this.settingsPrinter = new SettingRecordPrinter();
    }

    @Command(name="ListSettings", usage="Lists all settings in the system")
    public void listCerts(String[] args) {
        try {
            Collection settings = this.proxy.getSettings();
            if (settings == null || settings.size() == 0) {
                System.out.println("No settings found");
            } else {
                this.settingsPrinter.printRecords(settings);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to lookup certificates: " + e.getMessage());
        }
    }

    @Command(name="AddSetting", usage="Adds a name/value setting to the system.\r\n  name value \r\n\t name: The name of the new setting.\r\n\t value: The name of the new setting.  If the value has spaces, include the setting in quotes")
    public void addSetting(String[] args) {
        String name = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        String value = StringArrayUtil.getRequiredValue((String[])args, (int)1);
        try {
            Setting existingName = this.proxy.getSetting(name);
            if (existingName != null) {
                System.out.println("Setting " + name + " already exists");
                return;
            }
            this.proxy.addSetting(name, value);
            System.out.println("Setting " + name + " added successfully");
        }
        catch (Exception e) {
            System.out.println("Failed to add setting: " + e.getMessage());
        }
    }

    @Command(name="DeleteSetting", usage="Deletes a setting from the system\r\n  name \r\n\t name: The name of the setting to delete.")
    public void deleteSetting(String[] args) {
        String name = StringArrayUtil.getRequiredValue((String[])args, (int)0);
        try {
            Setting existingName = this.proxy.getSetting(name);
            if (existingName == null) {
                System.out.println("Setting " + name + " does not exists");
                return;
            }
            this.proxy.deleteSetting(name);
            System.out.println("Setting " + name + " deleted successfully");
        }
        catch (Exception e) {
            System.out.println("Failed to delete setting: " + e.getMessage());
        }
    }
}

