/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.model.Address;

public class AddressPrinter
extends AbstractRecordPrinter<Address> {
    protected static final String ADDRESS_ID_COL = "ID";
    protected static final String ADDRESS_NAME_COL = "Adress Name";
    protected static final String DIRECT_ADDRESS_COL = "Direct Address";
    protected static final String ENDPOINT_COL = "Endpoint";
    protected static final String TYPE_COL = "Type";
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList();

    public AddressPrinter() {
        super(170, REPORT_COLS);
    }

    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, Address record) {
        try {
            if (column.header.equals(ENDPOINT_COL) && StringUtils.isEmpty((CharSequence)record.getEndpoint())) {
                return "N/A";
            }
            if (column.header.equals(TYPE_COL) && StringUtils.isEmpty((CharSequence)record.getType())) {
                return "N/A";
            }
            return super.getColumnValue(column, (Object)record);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ADDRESS_ID_COL, 10, "Id"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ADDRESS_NAME_COL, 35, "DisplayName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(DIRECT_ADDRESS_COL, 50, "EmailAddress"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ENDPOINT_COL, 60, ENDPOINT_COL));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(TYPE_COL, 10, TYPE_COL));
    }
}

