/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.model.utils.CertUtils;

public class AnchorRecordPrinter
extends AbstractRecordPrinter<Anchor> {
    protected static final String ANCHOR_ID_COL = "ID";
    protected static final String ANCHOR_NAME_COL = "Anchor Name";
    protected static final String TP_NAME_COL = "Thumbprint";
    protected static final String OWNER_COL = "Owner";
    protected static final String INCOMING_COL = "Incoming";
    protected static final String OUTGOING_COL = "Outgoing";
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList();

    public AnchorRecordPrinter() {
        super(170, REPORT_COLS);
    }

    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, Anchor record) {
        try {
            X509Certificate anchor = CertUtils.toX509Certificate((byte[])record.getCertificateData());
            if (column.header.equals(ANCHOR_NAME_COL)) {
                X509Principal principal = PrincipalUtil.getSubjectX509Principal((X509Certificate)anchor);
                Vector values = principal.getValues(X509Name.CN);
                String cn = (String)values.get(0);
                return cn;
            }
            if (column.header.equals(TP_NAME_COL)) {
                return Thumbprint.toThumbprint((X509Certificate)anchor).toString();
            }
            if (column.header.equals(INCOMING_COL)) {
                return Boolean.valueOf(record.isIncoming()).toString();
            }
            if (column.header.equals(OUTGOING_COL)) {
                return Boolean.valueOf(record.isOutgoing()).toString();
            }
            return super.getColumnValue(column, (Object)record);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ANCHOR_ID_COL, 14, "Id"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(ANCHOR_NAME_COL, 50, "AnchorAsX509Certificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(TP_NAME_COL, 44, "AnchorAsX509Certificate"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(OWNER_COL, 40, OWNER_COL));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(INCOMING_COL, 10, INCOMING_COL));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(OUTGOING_COL, 10, OUTGOING_COL));
    }
}

