/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.nhindirect.config.manager.printers.DNSRecordPrinter;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.model.utils.CertUtils;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CERTRecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.TXTRecord;

/*
 * Exception performing whole class analysis ignored.
 */
public class DefaultDNSRecordPrinter
implements DNSRecordPrinter {
    private final PrintWriter writer = new PrintWriter(System.out);

    public void print(Collection<DNSRecord> records) {
        if (records == null || records.size() == 0) {
            this.writer.println("Empty record list");
            return;
        }
        for (DNSRecord record : records) {
            this.print(record);
        }
    }

    private String typeToString(int type) {
        switch (type) {
            case 1: {
                return "A";
            }
            case 15: {
                return "MX";
            }
            case 6: {
                return "SOA";
            }
            case 37: {
                return "CERT";
            }
            case 2: {
                return "NS";
            }
            case 5: {
                return "CNAME";
            }
            case 16: {
                return "TXT";
            }
        }
        return "Unknown";
    }

    public void print(DNSRecord record) {
        if (record == null) {
            this.writer.println("Null Resource Record");
            return;
        }
        this.writer.println("-----------");
        this.print("Record Name", record.getName());
        this.print("Type", this.typeToString(record.getType()));
        this.print("TTL", String.valueOf(record.getTtl()));
        switch (record.getType()) {
            default: {
                break;
            }
            case 1: {
                this.print((ARecord)this.toRecord(record));
                break;
            }
            case 6: {
                this.print((SOARecord)this.toRecord(record));
                break;
            }
            case 15: {
                this.print((MXRecord)this.toRecord(record));
                break;
            }
            case 37: {
                this.print((CERTRecord)this.toRecord(record));
                break;
            }
            case 16: {
                this.print((TXTRecord)this.toRecord(record));
                break;
            }
            case 5: {
                this.print((CNAMERecord)this.toRecord(record));
                break;
            }
            case 2: {
                this.print((NSRecord)this.toRecord(record));
            }
        }
        this.writer.flush();
    }

    private Name nameFromString(String str) {
        if (!str.endsWith(".")) {
            str = str + ".";
        }
        try {
            return Name.fromString((String)str);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid DNS name");
        }
    }

    private Record toRecord(DNSRecord rec) {
        return Record.newRecord((Name)this.nameFromString(rec.getName()), (int)rec.getType(), (int)rec.getDclass(), (long)rec.getTtl(), (byte[])rec.getData());
    }

    private void print(TXTRecord body) {
        if (body == null) {
            this.print("Null A Record Body");
            return;
        }
        this.print("Text", body.getStrings().get(0).toString());
    }

    private void print(CNAMERecord body) {
        if (body == null) {
            this.print("Null A Record Body");
            return;
        }
        this.print("Alias value", body.getAlias().toString());
    }

    private void print(ARecord body) {
        if (body == null) {
            this.print("Null A Record Body");
            return;
        }
        this.print("IPAddress", body.getAddress().getHostAddress());
    }

    private void print(MXRecord body) {
        if (body == null) {
            this.print("Null MX Record Body");
            return;
        }
        this.print("Access Exchage Server", body.getTarget().toString());
        this.print("Priority", String.valueOf(body.getPriority()));
    }

    private void print(SOARecord soa) {
        if (soa == null) {
            this.print("Null SOA Record Body");
            return;
        }
        this.print("DomainName", soa.getName().toString());
        this.print("Primary Name Server", soa.getHost().toString());
        this.print("Domain Manager:", soa.getAdmin().toString());
        this.print("Refresh", String.valueOf(soa.getRefresh()));
        this.print("Retry", String.valueOf(soa.getRetry()));
        this.print("Expire", String.valueOf(soa.getExpire()));
        this.print("Minimum", String.valueOf(soa.getMinimum()));
    }

    private void print(CERTRecord certbody) {
        if (certbody == null) {
            this.print("Null CERT Record Body");
            return;
        }
        Certificate cert = DefaultDNSRecordPrinter.parseCertRecord((CERTRecord)certbody);
        if (cert instanceof X509Certificate) {
            X509Certificate xcert = (X509Certificate)cert;
            this.print("Certificate Subject", xcert.getSubjectDN().getName());
        }
    }

    private void print(NSRecord ns) {
        if (ns == null) {
            this.print("Null NS Record Body");
            return;
        }
        this.print("DomainName", ns.getName().toString());
        this.print("Target Name Server", ns.getTarget().toString());
    }

    private void print(String name, String value) {
        this.writer.println(name + ": " + value);
    }

    private void print(String message) {
        this.writer.println(message);
    }

    private static Certificate parseCertRecord(CERTRecord r) {
        int type = r.getCertType();
        byte[] data = r.getCert();
        switch (type) {
            case 1: {
                return CertUtils.toX509Certificate((byte[])data);
            }
        }
        return null;
    }
}

