/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.model.Domain;

public class DomainPrinter
extends AbstractRecordPrinter<Domain> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList();
    protected static final String DOMAIN_ID_COL = "ID";
    protected static final String DOMAIN_NAME_COL = "Domain Name";
    protected static final String POSTMASTER_TYPE_COL = "Postmaster Email";
    protected static final String STATUS_COL = "Status";

    public DomainPrinter() {
        super(130, REPORT_COLS);
    }

    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, Domain domain) {
        try {
            if (column.header.equals(POSTMASTER_TYPE_COL)) {
                if (domain.getPostmasterAddress() == null || StringUtils.isEmpty((CharSequence)domain.getPostmasterAddress().toString())) {
                    return "<Not Configured>";
                }
                return domain.getPostmasterAddress().getEmailAddress();
            }
            return super.getColumnValue(column, (Object)domain);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(DOMAIN_ID_COL, 20, "Id"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(DOMAIN_NAME_COL, 40, "DomainName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POSTMASTER_TYPE_COL, 50, "PostmasterEmail"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(STATUS_COL, 20, STATUS_COL));
    }
}

