/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.util.ArrayList;
import java.util.Collection;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.model.CertPolicyGroup;

public class PolicyGroupPrinter
extends AbstractRecordPrinter<CertPolicyGroup> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList();
    protected static final String POLICY_GROUP_NAME_COL = "Policy Group Name";
    protected static final String POLICY_NUMBER_COL = "Number of Policies";

    public PolicyGroupPrinter() {
        super(57, REPORT_COLS);
    }

    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, CertPolicyGroup group) {
        try {
            if (column.header.equals(POLICY_NUMBER_COL)) {
                return Integer.toString(group.getPolicies() == null ? 0 : group.getPolicies().size());
            }
            return super.getColumnValue(column, (Object)group);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_GROUP_NAME_COL, 40, "PolicyGroupName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(POLICY_NUMBER_COL, 16, "Policies"));
    }
}

