/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.manager.printers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.nhindirect.config.manager.printers.AbstractRecordPrinter;
import org.nhindirect.config.model.TrustBundle;

public class TrustBundleRecordPrinter
extends AbstractRecordPrinter<TrustBundle> {
    protected static final Collection<AbstractRecordPrinter.ReportColumn> REPORT_COLS = new ArrayList();
    protected static final String BUNDLE_ID_COL = "ID";
    protected static final String BUNDLE_NAME_COL = "Bundle Name";
    protected static final String BUNDLE_URL_COL = "Bundle URL";
    protected static final String BUNDLE_REFRESH_COL = "Refresh Interval";
    protected static final String BUNDLE_LAST_CHECKED_COL = "Last Checked";
    protected static final String BUNDLE_LAST_UPDATED_COL = "Last Updated";
    protected final DateFormat dtFormat = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss");

    public TrustBundleRecordPrinter() {
        super(200, REPORT_COLS);
    }

    protected String getColumnValue(AbstractRecordPrinter.ReportColumn column, TrustBundle bundle) {
        try {
            if (column.header.equals(BUNDLE_LAST_CHECKED_COL)) {
                return bundle.getLastRefreshAttempt() == null ? "N/A" : this.dtFormat.format(bundle.getLastRefreshAttempt().getTime());
            }
            if (column.header.equals(BUNDLE_LAST_UPDATED_COL)) {
                return bundle.getLastSuccessfulRefresh() == null ? "N/A" : this.dtFormat.format(bundle.getLastSuccessfulRefresh().getTime());
            }
            if (column.header.equals(BUNDLE_REFRESH_COL)) {
                return bundle.getRefreshInterval() + " sec";
            }
            return super.getColumnValue(column, (Object)bundle);
        }
        catch (Exception e) {
            return "ERROR: " + e.getMessage();
        }
    }

    static {
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_ID_COL, 10, "Id"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_NAME_COL, 40, "BundleName"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_URL_COL, 80, "BundleURL"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_REFRESH_COL, 20, "RefreshInterval"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_LAST_CHECKED_COL, 30, "LastChecked"));
        REPORT_COLS.add(new AbstractRecordPrinter.ReportColumn(BUNDLE_LAST_UPDATED_COL, 30, BUNDLE_LAST_UPDATED_COL));
    }
}

