/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.nhindirect.config.model.BundleRefreshError;
import org.nhindirect.config.model.TrustBundleAnchor;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

public class TrustBundle {
    private long id = -1L;
    private String bundleName;
    private String bundleURL;
    private byte[] signingCertificateData;
    private Collection<TrustBundleAnchor> trustBundleAnchors;
    private int refreshInterval;
    private Calendar lastRefreshAttempt;
    private BundleRefreshError lastRefreshError;
    private Calendar lastSuccessfulRefresh;
    private Calendar createTime;
    private String checkSum;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getBundleURL() {
        return this.bundleURL;
    }

    public void setBundleURL(String bundleURL) {
        this.bundleURL = bundleURL;
    }

    public byte[] getSigningCertificateData() {
        return this.signingCertificateData;
    }

    public void setSigningCertificateData(byte[] signingCertificateData) {
        this.signingCertificateData = signingCertificateData;
    }

    public Collection<TrustBundleAnchor> getTrustBundleAnchors() {
        if (this.trustBundleAnchors == null) {
            this.trustBundleAnchors = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.trustBundleAnchors);
    }

    public void setTrustBundleAnchors(Collection<TrustBundleAnchor> trustBundleAnchors) {
        this.trustBundleAnchors = new ArrayList<TrustBundleAnchor>(trustBundleAnchors);
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public Calendar getLastRefreshAttempt() {
        return this.lastRefreshAttempt;
    }

    public void setLastRefreshAttempt(Calendar lastRefreshAttempt) {
        this.lastRefreshAttempt = lastRefreshAttempt;
    }

    public BundleRefreshError getLastRefreshError() {
        return this.lastRefreshError;
    }

    public void setLastRefreshError(BundleRefreshError lastRefreshError) {
        this.lastRefreshError = lastRefreshError;
    }

    public Calendar getLastSuccessfulRefresh() {
        return this.lastSuccessfulRefresh;
    }

    public void setLastSuccessfulRefresh(Calendar lastSuccessfulRefresh) {
        this.lastSuccessfulRefresh = lastSuccessfulRefresh;
    }

    public Calendar getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Calendar createTime) {
        this.createTime = createTime;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = checkSum;
    }

    @JsonIgnore
    public X509Certificate getSigningCertificateAsX509Certificate() {
        X509Certificate x509Certificate;
        if (this.signingCertificateData == null || this.signingCertificateData.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(this.signingCertificateData);
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        }
        catch (Exception e) {
            try {
                throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bais);
        return x509Certificate;
    }
}

