/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

public class TrustBundleAnchor {
    private long id = -1L;
    private byte[] anchorData;
    private String thumbprint;
    private Calendar validStartDate;
    private Calendar validEndDate;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte[] getAnchorData() {
        return this.anchorData;
    }

    public void setAnchorData(byte[] anchorData) {
        this.anchorData = anchorData;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    @JsonIgnore
    public X509Certificate getAsX509Certificate() {
        X509Certificate x509Certificate;
        if (this.anchorData == null || this.anchorData.length == 0) {
            return null;
        }
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(this.anchorData);
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
        }
        catch (Exception e) {
            try {
                throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bais);
        return x509Certificate;
    }
}

