/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model.utils;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.nhindirect.config.model.utils.CertUtils;

public class CertUtils_certAndWrappedKeyToRawByteFormatTest {
    @Test
    public void testWrapToRawBytes_assertConverted() throws Exception {
        byte[] key = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552Key.der"));
        X509Certificate cert = CertUtils.toX509Certificate((byte[])FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/gm2552.der")));
        byte[] rawBytes = CertUtils.certAndWrappedKeyToRawByteFormat((byte[])key, (X509Certificate)cert);
        Assertions.assertNotNull((Object)rawBytes);
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])rawBytes);
        Assertions.assertEquals((Object)cert, (Object)container.getCert());
        Assertions.assertTrue((boolean)Arrays.equals(key, container.getWrappedKeyData()));
        Assertions.assertNull((Object)container.getKey());
    }

    @Test
    public void testWrapToRawBytes_signedBytesInSize_assertConverted() throws Exception {
        byte[] rawP12 = FileUtils.readFileToByteArray((File)new File("./src/test/resources/certs/certCheckA.p12"));
        CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])rawP12);
        byte[] rawBytes = CertUtils.certAndWrappedKeyToRawByteFormat((byte[])cont.getKey().getEncoded(), (X509Certificate)cont.getCert());
        Assertions.assertNotNull((Object)rawBytes);
        CertUtils.CertContainer container = CertUtils.toCertContainer((byte[])rawBytes);
        Assertions.assertEquals((Object)cont.getCert(), (Object)container.getCert());
        Assertions.assertTrue((boolean)Arrays.equals(cont.getKey().getEncoded(), container.getWrappedKeyData()));
        Assertions.assertNull((Object)container.getKey());
    }
}

