/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Anchor {
    private String owner;
    private String thumbprint;
    private long certificateId;
    private byte[] certificateData;
    private long id = -1L;
    private Calendar createTime;
    private Calendar validStartDate;
    private Calendar validEndDate;
    private EntityStatus status;
    private boolean incoming;
    private boolean outgoing;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsonIgnore
    public X509Certificate getAnchorAsX509Certificate() {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.certificateData);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            return x509Certificate;
        }
        catch (IOException | CertificateException e) {
            throw new CertificateConversionException(e);
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public long getCertificateId() {
        return this.certificateId;
    }

    public byte[] getCertificateData() {
        return this.certificateData;
    }

    public long getId() {
        return this.id;
    }

    public Calendar getCreateTime() {
        return this.createTime;
    }

    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public boolean isOutgoing() {
        return this.outgoing;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public void setCertificateId(long certificateId) {
        this.certificateId = certificateId;
    }

    public void setCertificateData(byte[] certificateData) {
        this.certificateData = certificateData;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setCreateTime(Calendar createTime) {
        this.createTime = createTime;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    public void setStatus(EntityStatus status) {
        this.status = status;
    }

    public void setIncoming(boolean incoming) {
        this.incoming = incoming;
    }

    public void setOutgoing(boolean outgoing) {
        this.outgoing = outgoing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCertificateId() != other.getCertificateId()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isIncoming() != other.isIncoming()) {
            return false;
        }
        if (this.isOutgoing() != other.isOutgoing()) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$thumbprint = this.getThumbprint();
        String other$thumbprint = other.getThumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        if (!Arrays.equals(this.getCertificateData(), other.getCertificateData())) {
            return false;
        }
        Calendar this$createTime = this.getCreateTime();
        Calendar other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Calendar this$validStartDate = this.getValidStartDate();
        Calendar other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        Calendar this$validEndDate = this.getValidEndDate();
        Calendar other$validEndDate = other.getValidEndDate();
        if (this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate)) {
            return false;
        }
        EntityStatus this$status = this.getStatus();
        EntityStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Anchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $certificateId = this.getCertificateId();
        result = result * 59 + (int)($certificateId >>> 32 ^ $certificateId);
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isIncoming() ? 79 : 97);
        result = result * 59 + (this.isOutgoing() ? 79 : 97);
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $thumbprint = this.getThumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        result = result * 59 + Arrays.hashCode(this.getCertificateData());
        Calendar $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Calendar $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        Calendar $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        EntityStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }

    public String toString() {
        return "Anchor(owner=" + this.getOwner() + ", thumbprint=" + this.getThumbprint() + ", certificateId=" + this.getCertificateId() + ", certificateData=" + Arrays.toString(this.getCertificateData()) + ", id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", validStartDate=" + this.getValidStartDate() + ", validEndDate=" + this.getValidEndDate() + ", status=" + (Object)((Object)this.getStatus()) + ", incoming=" + this.isIncoming() + ", outgoing=" + this.isOutgoing() + ")";
    }
}

