/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.nhindirect.config.model.BundleRefreshError;
import org.nhindirect.config.model.TrustBundleAnchor;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustBundle {
    private long id = -1L;
    private String bundleName;
    private String bundleURL;
    private byte[] signingCertificateData;
    private Collection<TrustBundleAnchor> trustBundleAnchors;
    private int refreshInterval;
    private Calendar lastRefreshAttempt;
    private BundleRefreshError lastRefreshError;
    private Calendar lastSuccessfulRefresh;
    private Calendar createTime;
    private String checkSum;

    public Collection<TrustBundleAnchor> getTrustBundleAnchors() {
        if (this.trustBundleAnchors == null) {
            this.trustBundleAnchors = Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.trustBundleAnchors);
    }

    public void setTrustBundleAnchors(Collection<TrustBundleAnchor> trustBundleAnchors) {
        this.trustBundleAnchors = new ArrayList<TrustBundleAnchor>(trustBundleAnchors);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsonIgnore
    public X509Certificate getSigningCertificateAsX509Certificate() {
        if (this.signingCertificateData == null) return null;
        if (this.signingCertificateData.length == 0) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.signingCertificateData);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
        }
    }

    public long getId() {
        return this.id;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundleURL() {
        return this.bundleURL;
    }

    public byte[] getSigningCertificateData() {
        return this.signingCertificateData;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public Calendar getLastRefreshAttempt() {
        return this.lastRefreshAttempt;
    }

    public BundleRefreshError getLastRefreshError() {
        return this.lastRefreshError;
    }

    public Calendar getLastSuccessfulRefresh() {
        return this.lastSuccessfulRefresh;
    }

    public Calendar getCreateTime() {
        return this.createTime;
    }

    public String getCheckSum() {
        return this.checkSum;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public void setBundleURL(String bundleURL) {
        this.bundleURL = bundleURL;
    }

    public void setSigningCertificateData(byte[] signingCertificateData) {
        this.signingCertificateData = signingCertificateData;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setLastRefreshAttempt(Calendar lastRefreshAttempt) {
        this.lastRefreshAttempt = lastRefreshAttempt;
    }

    public void setLastRefreshError(BundleRefreshError lastRefreshError) {
        this.lastRefreshError = lastRefreshError;
    }

    public void setLastSuccessfulRefresh(Calendar lastSuccessfulRefresh) {
        this.lastSuccessfulRefresh = lastSuccessfulRefresh;
    }

    public void setCreateTime(Calendar createTime) {
        this.createTime = createTime;
    }

    public void setCheckSum(String checkSum) {
        this.checkSum = checkSum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustBundle)) {
            return false;
        }
        TrustBundle other = (TrustBundle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getRefreshInterval() != other.getRefreshInterval()) {
            return false;
        }
        String this$bundleName = this.getBundleName();
        String other$bundleName = other.getBundleName();
        if (this$bundleName == null ? other$bundleName != null : !this$bundleName.equals(other$bundleName)) {
            return false;
        }
        String this$bundleURL = this.getBundleURL();
        String other$bundleURL = other.getBundleURL();
        if (this$bundleURL == null ? other$bundleURL != null : !this$bundleURL.equals(other$bundleURL)) {
            return false;
        }
        if (!Arrays.equals(this.getSigningCertificateData(), other.getSigningCertificateData())) {
            return false;
        }
        Collection<TrustBundleAnchor> this$trustBundleAnchors = this.getTrustBundleAnchors();
        Collection<TrustBundleAnchor> other$trustBundleAnchors = other.getTrustBundleAnchors();
        if (this$trustBundleAnchors == null ? other$trustBundleAnchors != null : !((Object)this$trustBundleAnchors).equals(other$trustBundleAnchors)) {
            return false;
        }
        Calendar this$lastRefreshAttempt = this.getLastRefreshAttempt();
        Calendar other$lastRefreshAttempt = other.getLastRefreshAttempt();
        if (this$lastRefreshAttempt == null ? other$lastRefreshAttempt != null : !((Object)this$lastRefreshAttempt).equals(other$lastRefreshAttempt)) {
            return false;
        }
        BundleRefreshError this$lastRefreshError = this.getLastRefreshError();
        BundleRefreshError other$lastRefreshError = other.getLastRefreshError();
        if (this$lastRefreshError == null ? other$lastRefreshError != null : !((Object)((Object)this$lastRefreshError)).equals((Object)other$lastRefreshError)) {
            return false;
        }
        Calendar this$lastSuccessfulRefresh = this.getLastSuccessfulRefresh();
        Calendar other$lastSuccessfulRefresh = other.getLastSuccessfulRefresh();
        if (this$lastSuccessfulRefresh == null ? other$lastSuccessfulRefresh != null : !((Object)this$lastSuccessfulRefresh).equals(other$lastSuccessfulRefresh)) {
            return false;
        }
        Calendar this$createTime = this.getCreateTime();
        Calendar other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$checkSum = this.getCheckSum();
        String other$checkSum = other.getCheckSum();
        return !(this$checkSum == null ? other$checkSum != null : !this$checkSum.equals(other$checkSum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustBundle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getRefreshInterval();
        String $bundleName = this.getBundleName();
        result = result * 59 + ($bundleName == null ? 43 : $bundleName.hashCode());
        String $bundleURL = this.getBundleURL();
        result = result * 59 + ($bundleURL == null ? 43 : $bundleURL.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSigningCertificateData());
        Collection<TrustBundleAnchor> $trustBundleAnchors = this.getTrustBundleAnchors();
        result = result * 59 + ($trustBundleAnchors == null ? 43 : ((Object)$trustBundleAnchors).hashCode());
        Calendar $lastRefreshAttempt = this.getLastRefreshAttempt();
        result = result * 59 + ($lastRefreshAttempt == null ? 43 : ((Object)$lastRefreshAttempt).hashCode());
        BundleRefreshError $lastRefreshError = this.getLastRefreshError();
        result = result * 59 + ($lastRefreshError == null ? 43 : ((Object)((Object)$lastRefreshError)).hashCode());
        Calendar $lastSuccessfulRefresh = this.getLastSuccessfulRefresh();
        result = result * 59 + ($lastSuccessfulRefresh == null ? 43 : ((Object)$lastSuccessfulRefresh).hashCode());
        Calendar $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $checkSum = this.getCheckSum();
        result = result * 59 + ($checkSum == null ? 43 : $checkSum.hashCode());
        return result;
    }

    public String toString() {
        return "TrustBundle(id=" + this.getId() + ", bundleName=" + this.getBundleName() + ", bundleURL=" + this.getBundleURL() + ", signingCertificateData=" + Arrays.toString(this.getSigningCertificateData()) + ", trustBundleAnchors=" + this.getTrustBundleAnchors() + ", refreshInterval=" + this.getRefreshInterval() + ", lastRefreshAttempt=" + this.getLastRefreshAttempt() + ", lastRefreshError=" + (Object)((Object)this.getLastRefreshError()) + ", lastSuccessfulRefresh=" + this.getLastSuccessfulRefresh() + ", createTime=" + this.getCreateTime() + ", checkSum=" + this.getCheckSum() + ")";
    }
}

